package org.mule.weave.v2.parser.phase

trait BaseParsingContextSettings {
  def removeShadowedImplicitInputs: Boolean
  def javaModuleLoaderLoadTypes: Boolean
  def javaModuleLoaderDeterministicFunctionsOrdering: Boolean
  def enableVarsMaterializationPass: Boolean
  def forcedMaterializationVariables: Seq[String]
}

object DefaultParsingContextSettings extends BaseParsingContextSettings {
  override def removeShadowedImplicitInputs: Boolean = true
  override def javaModuleLoaderLoadTypes: Boolean = true
  override def javaModuleLoaderDeterministicFunctionsOrdering: Boolean = true
  override def enableVarsMaterializationPass: Boolean = true
  override def forcedMaterializationVariables: Seq[String] = Seq.empty
}