package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.TypeMismatch
import org.mule.weave.v2.ts.BooleanType
import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.VariableConstraints
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object AndTypeResolver extends WeaveTypeResolver {

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val edges: Seq[Edge] = node.incomingEdges()
    val isFalse = edges.exists(_.mayBeIncomingType() match {
      case Some(BooleanType(Some(false), _)) => true
      case _                                 => false
    })

    val isTrue: Boolean = edges.forall(_.mayBeIncomingType() match {
      case Some(BooleanType(Some(true), _)) => true
      case _                                => false
    })
    val value =
      if (isFalse)
        Some(false)
      else if (isTrue)
        Some(true)
      else
        None

    val incoming_constraints = edges
      .flatMap(_.mayBeIncomingType())
      .map({
        case BooleanType(_, constr) => constr
        case _                      => VariableConstraints.emptyConstraints()
      })

    val constraints = if (incoming_constraints.nonEmpty) {
      incoming_constraints.reduce((x, y) => x.conjunction(y))
    } else {
      VariableConstraints.emptyConstraints()
    }

    Some(BooleanType(value, constraints))
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    node.incomingEdges().map((_, BooleanType()))
  }
}
