import * from dw::http::Server
import * from dw::http::Types
import * from dw::core::Objects
import * from dw::Runtime
import * from dw::http::Interceptors

type TypedValue = {
  content: String, //TODO: should content be a binary??
  contentType: String
}

type Named = {
  name: String
}

type Configurable = {
  "options"?: Object
}

type WeaveInput = Named & TypedValue & Configurable


type TransformRequest = {
  inputs: Array<WeaveInput>,
  script: String
}

type TypeRequest = TypedValue & Configurable

var defaultServerConfig =
{
  "host": "localhost",
  "port": 8080,
  "contentType": "application/json"
}

fun exec(script: String, inputs: Array<WeaveInput>): TypedValue = native("playground::ExecFunction")

fun weaveTypeOf(sampleData: String, contentType: String, options: Object = {}): String | Null = native("playground::WeaveTypeOfFunction")

fun buildTransformResponse(requestBody: TransformRequest) =
  {
    body: try(() -> exec(requestBody.script, requestBody.inputs)),
    headers: {
      "Content-Type": "application/json"
    }
  }

fun buildTypesResponse(responseBody: Any) = {
  body: {
    success: responseBody != null,
    result: responseBody
  },
  headers: {
    "Content-Type": "application/json"
  }
}

fun start(serverConfig: ApiConfig = defaultServerConfig) =
  api(serverConfig mergeWith {interceptors: [CORS()]},
    {
      "/transform": {
        POST: ((request) -> buildTransformResponse(request.body as TransformRequest))
      },
      "/": {
        GET: ((request) -> serveResource("/index.html"))
      },
      "/type": {
        "POST": ((request) ->
          buildTypesResponse(
            request.body match {
              case x is TypeRequest -> weaveTypeOf(x.content, x.contentType, x.options default {})
              else -> null
            }
          )
        )
      },
      //TODO: need uri params to extract parts of the path
      "/.+": {
        GET: ((request) -> serveResource(request.path))
      }
    }
  )
  //wait 60000

