import * from dw::http::Server
import * from dw::Runtime

type TypedValue = {
  content: String, //TODO: should content be a binary??
  "Content-Type": String
}

type Named = {
  name: String
}

type WeaveInput = Named & TypedValue

type TransformRequest = {
  inputs: Array<WeaveInput>,
  script: String
}

var defaultServerConfig =
{
  "host": "localhost",
  "port": 8080,
  "Content-Type": "application/json"
}

fun exec(script: String, inputs: Array<WeaveInput>): TypedValue = native("playground::ExecFunction")

fun buildResponse(body: TransformRequest) =
{
  body: try(() -> exec(body.script, body.inputs)),
  headers: {
    "Content-Type": "application/json"
  }
}

fun start(serverConfig = defaultServerConfig) =
  api(serverConfig,
    {
      "/transform": {
        POST: ((request) -> buildResponse(request.body as TransformRequest)) as HttpHandler
      },
      "/": {
        GET: ((request) -> serveResource("/static.html")) as HttpHandler
      },
      //TODO: need uri params to extract parts of the path
      "/.+": {
        GET: ((request) -> serveResource(request.path)) as HttpHandler
      }
    }
  )
  //wait 60000

