/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.protobuf.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.InputStream;
import java.io.Serializable;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.protobuf.exception.ProtoBufWritingException;
import org.mule.weave.v2.module.protobuf.utils.CommonValues$;
import org.mule.weave.v2.module.protobuf.utils.EnumParser$;
import org.mule.weave.v2.module.protobuf.utils.FieldParser$;
import org.mule.weave.v2.module.protobuf.utils.MessageParser$;
import org.mule.weave.v2.module.protobuf.utils.ProtobufWireTypes$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.matching.Regex;

public final class DWToProtoConverter$ {
    public static DWToProtoConverter$ MODULE$;
    private final Regex unknownFieldRegex;

    static {
        new DWToProtoConverter$();
    }

    public Object DWValueToProto(Value<?> value, Descriptors.FieldDescriptor fdesc, EvaluationContext ctx) {
        Descriptors.FieldDescriptor.JavaType javaType = fdesc.getJavaType();
        if (Descriptors.FieldDescriptor.JavaType.DOUBLE.equals(javaType)) {
            return BoxesRunTime.boxToDouble((double)this.DWValueToDouble(value, ctx));
        }
        if (Descriptors.FieldDescriptor.JavaType.FLOAT.equals(javaType)) {
            return BoxesRunTime.boxToFloat((float)this.DWValueToFloat(value, ctx));
        }
        if (Descriptors.FieldDescriptor.JavaType.LONG.equals(javaType)) {
            return BoxesRunTime.boxToLong((long)this.DWValueToLong(value, ctx));
        }
        if (Descriptors.FieldDescriptor.JavaType.INT.equals(javaType)) {
            return BoxesRunTime.boxToInteger((int)this.DWValueToInt(value, ctx));
        }
        if (Descriptors.FieldDescriptor.JavaType.BOOLEAN.equals(javaType)) {
            return BoxesRunTime.boxToBoolean((boolean)this.DWValueToBool(value, ctx));
        }
        if (Descriptors.FieldDescriptor.JavaType.STRING.equals(javaType)) {
            return this.DWValueToString(value, ctx);
        }
        if (Descriptors.FieldDescriptor.JavaType.MESSAGE.equals(javaType)) {
            return this.DWValueToMessage(value, fdesc.getMessageType(), ctx);
        }
        if (Descriptors.FieldDescriptor.JavaType.BYTE_STRING.equals(javaType)) {
            return this.DWValueToByteString(value, ctx);
        }
        if (Descriptors.FieldDescriptor.JavaType.ENUM.equals(javaType)) {
            return this.DWValueToEnum(value, fdesc.getEnumType(), ctx);
        }
        throw new ProtoBufWritingException(value.location(), new StringBuilder(54).append("The ProtoBuf ").append(javaType).append(" is not supported by the DataWeave writer").toString());
    }

    private double DWValueToDouble(Value<?> value, EvaluationContext ctx) {
        if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            return v.toDouble();
        }
        throw new ProtoBufWritingException(value.location(), "Can't write as a Double");
    }

    private float DWValueToFloat(Value<?> value, EvaluationContext ctx) {
        if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            return v.toFloat();
        }
        throw new ProtoBufWritingException(value.location(), "Can't write as a Float");
    }

    private long DWValueToLong(Value<?> value, EvaluationContext ctx) {
        if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            return v.toLong();
        }
        if (KeyType$.MODULE$.accepts(value, ctx)) {
            long l;
            try {
                Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                l = v.toLong();
            }
            catch (Exception e) {
                throw new ProtoBufWritingException(value.location(), "Can't parse as a Long");
            }
            return l;
        }
        throw new ProtoBufWritingException(value.location(), "Can't write as a Long");
    }

    private int DWValueToInt(Value<?> value, EvaluationContext ctx) {
        if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            return v.toInt();
        }
        if (KeyType$.MODULE$.accepts(value, ctx)) {
            int n;
            try {
                Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                n = v.toInt();
            }
            catch (Exception e) {
                throw new ProtoBufWritingException(value.location(), "Can't parse as an Int");
            }
            return n;
        }
        throw new ProtoBufWritingException(value.location(), "Can't write as an Int");
    }

    private boolean DWValueToBool(Value<?> value, EvaluationContext ctx) {
        if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean v = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            return v;
        }
        if (KeyType$.MODULE$.accepts(value, ctx)) {
            boolean bl;
            try {
                boolean v;
                bl = v = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            }
            catch (Exception e) {
                throw new ProtoBufWritingException(value.location(), "Can't parse as a Boolean");
            }
            return bl;
        }
        throw new ProtoBufWritingException(value.location(), "Can't write as a Boolean");
    }

    private String DWValueToString(Value<?> value, EvaluationContext ctx) {
        if (StringType$.MODULE$.accepts(value, ctx) || KeyType$.MODULE$.accepts(value, ctx)) {
            CharSequence v = (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            return ((Object)v).toString();
        }
        throw new ProtoBufWritingException(value.location(), "Can't write as a String");
    }

    private ByteString DWValueToByteString(Value<?> value, EvaluationContext ctx) {
        if (BinaryType$.MODULE$.accepts(value, ctx)) {
            return ByteString.readFrom((InputStream)((InputStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx)));
        }
        throw new ProtoBufWritingException(value.location(), "Can't write as a Binary");
    }

    private Descriptors.EnumValueDescriptor DWValueToEnum(Value<?> value, Descriptors.EnumDescriptor edesc, EvaluationContext ctx) {
        return (Descriptors.EnumValueDescriptor)EnumParser$.MODULE$.writeEnum(value, edesc, ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (StringType$.MODULE$.accepts(value, ctx)) {
                Some some;
                Number index;
                CharSequence v;
                CharSequence charSequence = v = (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                String string = CommonValues$.MODULE$.unrecognizedEnum();
                if (!(charSequence != null ? !charSequence.equals(string) : string != null)) {
                    Option option = DWToProtoConverter$.getIndexFromValue$1(value, ctx);
                    if (option instanceof Some) {
                        Some some2 = (Some)option;
                        Number index2 = (Number)some2.value();
                        return edesc.findValueByNumberCreatingIfUnknown(index2.toInt());
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new ProtoBufWritingException(value.location(), "Can't write as an Enum since no index was specified");
                    }
                    throw new MatchError((Object)option);
                }
                Descriptors.EnumValueDescriptor enumValue = edesc.findValueByName(((Object)v).toString());
                if (enumValue == null) {
                    throw new ProtoBufWritingException(value.location(), new StringBuilder(22).append("Can't find Enum value ").append(((Object)v).toString()).toString());
                }
                Option option = DWToProtoConverter$.getIndexFromValue$1(value, ctx);
                if (option instanceof Some && (index = (Number)(some = (Some)option).value()).toInt() != enumValue.getNumber()) {
                    throw new ProtoBufWritingException(value.location(), new StringBuilder(42).append("Enum ").append(((Object)v).toString()).append(" value has index ").append(enumValue.getNumber()).append(", but ").append(index).append(" was specified").toString());
                }
                return enumValue;
            }
            throw new ProtoBufWritingException(value.location(), "Can't write as an Enum");
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public UnknownFieldSet.Field DWValueToUnknown(Value<?> value, EvaluationContext ctx) {
        UnknownFieldSet.Field.Builder builder;
        UnknownFieldSet.Field.Builder builder2 = UnknownFieldSet.Field.newBuilder();
        if (NumberType$.MODULE$.accepts(value, ctx)) {
            boolean bl;
            String wireType;
            LazyRef numberValue$lzy = new LazyRef();
            Option maybeWireType = DWToProtoConverter$.getWireTypeFromValue$1(value, ctx);
            Option option = maybeWireType;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                builder = builder2.addVarint(DWToProtoConverter$.numberValue$1(numberValue$lzy, value, ctx).toLong());
                return builder2.build();
            }
            Some some = (Some)option;
            String string = wireType = (String)some.value();
            String string2 = ProtobufWireTypes$.MODULE$.Varint();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                builder = builder2.addVarint(DWToProtoConverter$.numberValue$1(numberValue$lzy, value, ctx).toLong());
                return builder2.build();
            }
            String string4 = ProtobufWireTypes$.MODULE$._32Bit();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                builder = builder2.addFixed32(DWToProtoConverter$.numberValue$1(numberValue$lzy, value, ctx).toInt());
                return builder2.build();
            }
            String string6 = ProtobufWireTypes$.MODULE$._64Bit();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                builder = builder2.addFixed64(DWToProtoConverter$.numberValue$1(numberValue$lzy, value, ctx).toLong());
                return builder2.build();
            }
            String string8 = ProtobufWireTypes$.MODULE$.Group();
            String string9 = string;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                bl = true;
            } else {
                String string10 = ProtobufWireTypes$.MODULE$.LengthDelimited();
                String string11 = string;
                bl = !(string10 != null ? !string10.equals(string11) : string11 != null);
            }
            if (!bl) throw new MatchError((Object)string);
            throw new ProtoBufWritingException(value.location(), new StringBuilder(48).append("Can't set it to an unknown number with wireType ").append(wireType).toString());
        }
        if (!BinaryType$.MODULE$.accepts(value, ctx)) throw new ProtoBufWritingException(value.location(), "Can't set it to an unknown. Only Numbers and Binaries are allowed");
        if (DWToProtoConverter$.getWireTypeFromValue$1(value, ctx).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DWToProtoConverter$.$anonfun$DWValueToUnknown$7(x$4)))) {
            throw new ProtoBufWritingException(value.location(), "Can only set Binaries to length delimited wire types.");
        }
        SeekableStream binaryValue = (SeekableStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        builder = builder2.addLengthDelimited(ByteString.readFrom((InputStream)((InputStream)binaryValue)));
        return builder2.build();
    }

    public Regex unknownFieldRegex() {
        return this.unknownFieldRegex;
    }

    public Message DWValueToMessage(Value<?> value, Descriptors.Descriptor desc, EvaluationContext ctx) {
        return (Message)MessageParser$.MODULE$.writeMessage(value, desc, ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (ObjectType$.MODULE$.accepts(value, ctx)) {
                Set presentOneOf = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                Set presentKeys = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                ObjectSeq objectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
                DynamicMessage.Builder b = DynamicMessage.newBuilder((Descriptors.Descriptor)desc);
                objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    String name = ((QualifiedName)f._1().evaluate(ctx)).name();
                    Descriptors.FieldDescriptor fdesc = desc.findFieldByName(name);
                    if (fdesc == null) {
                        String string = name;
                        Option option = MODULE$.unknownFieldRegex().unapplySeq((CharSequence)string);
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                            String index = (String)((LinearSeqOptimized)option.get()).apply(0);
                            return b.mergeUnknownFields(UnknownFieldSet.newBuilder().addField(new StringOps(Predef$.MODULE$.augmentString(index)).toInt(), MODULE$.DWValueToUnknown(f._2(), ctx)).build());
                        }
                        throw new ProtoBufWritingException(f._1().location(), "Field name not supported. Only field names present in the schema and unknowns are valid.");
                    }
                    if (!fdesc.isRepeated() && presentKeys.contains((Object)fdesc)) {
                        throw new ProtoBufWritingException(f._1().location(), new StringBuilder(51).append("The field ").append(fdesc.getFullName()).append(" has already been set and is not repeated").toString());
                    }
                    return (DynamicMessage.Builder)FieldParser$.MODULE$.writeField(f._2(), fdesc, ctx).map((Function1 & Serializable & scala.Serializable)value -> b.setField(fdesc, value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Object object;
                        Descriptors.OneofDescriptor fdescOneOf = fdesc.getContainingOneof();
                        if (fdescOneOf != null) {
                            if (presentOneOf.contains((Object)fdescOneOf)) {
                                throw new ProtoBufWritingException(f._1().location(), new StringBuilder(56).append("The oneof ").append(fdescOneOf.getFullName()).append(" has already been set with another field name.").toString());
                            }
                            object = BoxesRunTime.boxToBoolean((boolean)presentOneOf.add((Object)fdescOneOf));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        if (fdesc.isRepeated()) {
                            return b.addRepeatedField(fdesc, MODULE$.DWValueToProto(f._2(), fdesc, ctx));
                        }
                        presentKeys.add((Object)fdesc);
                        return b.setField(fdesc, MODULE$.DWValueToProto(f._2(), fdesc, ctx));
                    });
                });
                return b.build();
            }
            throw new ProtoBufWritingException(value.location(), "Can't write as an Object");
        });
    }

    private static final Option getIndexFromValue$1(Value value, EvaluationContext ctx$1) {
        return value.schema(ctx$1).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.valueOf(CommonValues$.MODULE$.ENUM_INDEX_PROPERTY_NAME(), ctx$1).withFilter((Function1 & Serializable & scala.Serializable)indexPropt -> BoxesRunTime.boxToBoolean((boolean)NumberType$.MODULE$.accepts(indexPropt, ctx$1))).map((Function1 & Serializable & scala.Serializable)indexPropt -> {
            Number indexEvaluated = (Number)NumberType$.MODULE$.coerce(indexPropt, ctx$1).evaluate(ctx$1);
            return new Tuple2(indexPropt, (Object)indexEvaluated);
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Number indexEvaluated = (Number)tuple2._2();
                return indexEvaluated;
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$DWValueToUnknown$5(CharSequence wireTypeEvaluated$1, String x$2) {
        String string = x$2;
        CharSequence charSequence = wireTypeEvaluated$1;
        return !(string != null ? !string.equals(charSequence) : charSequence != null);
    }

    private static final Option getWireTypeFromValue$1(Value value, EvaluationContext ctx$2) {
        return value.schema(ctx$2).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.valueOf(ProtobufWireTypes$.MODULE$.WIRE_TYPE_PROPERTY_NAME(), ctx$2).withFilter((Function1 & Serializable & scala.Serializable)wireTypeProp -> BoxesRunTime.boxToBoolean((boolean)StringType$.MODULE$.accepts(wireTypeProp, ctx$2))).map((Function1 & Serializable & scala.Serializable)wireTypeProp -> {
            CharSequence wireTypeEvaluated = (CharSequence)StringType$.MODULE$.coerce(wireTypeProp, ctx$2).evaluate(ctx$2);
            return new Tuple2(wireTypeProp, (Object)wireTypeEvaluated);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                CharSequence wireTypeEvaluated = (CharSequence)tuple2._2();
                return ProtobufWireTypes$.MODULE$.values().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DWToProtoConverter$.$anonfun$DWValueToUnknown$5(wireTypeEvaluated, x$2))).map((Function1 & Serializable & scala.Serializable)foundWireType -> foundWireType);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private static final /* synthetic */ Number numberValue$lzycompute$1(LazyRef numberValue$lzy$1, Value value$2, EvaluationContext ctx$2) {
        Number number;
        LazyRef lazyRef = numberValue$lzy$1;
        synchronized (lazyRef) {
            number = numberValue$lzy$1.initialized() ? (Number)numberValue$lzy$1.value() : (Number)numberValue$lzy$1.initialize(NumberType$.MODULE$.coerce(value$2, ctx$2).evaluate(ctx$2));
        }
        return number;
    }

    private static final Number numberValue$1(LazyRef numberValue$lzy$1, Value value$2, EvaluationContext ctx$2) {
        if (numberValue$lzy$1.initialized()) {
            return (Number)numberValue$lzy$1.value();
        }
        return DWToProtoConverter$.numberValue$lzycompute$1(numberValue$lzy$1, value$2, ctx$2);
    }

    public static final /* synthetic */ boolean $anonfun$DWValueToUnknown$7(String x$4) {
        String string = x$4;
        String string2 = ProtobufWireTypes$.MODULE$.LengthDelimited();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private DWToProtoConverter$() {
        MODULE$ = this;
        this.unknownFieldRegex = new StringOps(Predef$.MODULE$.augmentString("-(\\d*)")).r();
    }
}

