/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.protobuf.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValueBuilder;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Converter$ {
    public static Converter$ MODULE$;

    static {
        new Converter$();
    }

    public ObjectValue protoMessageToDWValue(Message msg) {
        Descriptors.Descriptor desc = msg.getDescriptorForType();
        Buffer fields = JavaConverters$.MODULE$.asScalaBuffer(desc.getFields());
        ObjectValueBuilder builder = new ObjectValueBuilder();
        fields.foreach((Function1 & Serializable & scala.Serializable)fd -> {
            Object object;
            String n = fd.getName();
            Object value = msg.getField(fd);
            if (fd.isRepeated()) {
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((List)value)).asScala()).foreach((Function1 & Serializable & scala.Serializable)f -> builder.addPair(n, MODULE$.protoToDWValue(f, (Descriptors.FieldDescriptor)fd)));
                object = BoxedUnit.UNIT;
            } else {
                object = msg.hasField(fd) || fd.getContainingOneof() == null ? builder.addPair(n, MODULE$.protoToDWValue(value, (Descriptors.FieldDescriptor)fd)) : BoxedUnit.UNIT;
            }
            return object;
        });
        return builder.build();
    }

    private Value<?> protoToDWValue(Object value, Descriptors.FieldDescriptor fd) {
        Value value2;
        if (value instanceof Double) {
            value2 = NumberValue$.MODULE$.safe(BoxesRunTime.unboxToDouble((Object)value));
        } else if (value instanceof Float) {
            value2 = NumberValue$.MODULE$.safe((double)BoxesRunTime.unboxToFloat((Object)value));
        } else if (value instanceof Long) {
            value2 = NumberValue$.MODULE$.safe((double)BoxesRunTime.unboxToLong((Object)value));
        } else if (value instanceof Integer) {
            value2 = NumberValue$.MODULE$.safe((double)BoxesRunTime.unboxToInt((Object)value));
        } else if (value instanceof Boolean) {
            value2 = BooleanValue$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)value), BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3());
        } else if (value instanceof Message) {
            value2 = this.protoMessageToDWValue((Message)value);
        } else if (value instanceof ByteString) {
            value2 = BinaryValue$.MODULE$.apply(((ByteString)value).toByteArray());
        } else if (value instanceof String) {
            value2 = StringValue$.MODULE$.apply((String)value);
        } else if (value instanceof Descriptors.EnumValueDescriptor) {
            value2 = StringValue$.MODULE$.apply(((Descriptors.EnumValueDescriptor)value).getName());
        } else {
            throw new Exception("Not supported proto value");
        }
        return value2;
    }

    private Object DWValueToProto(Value<?> value, Descriptors.FieldDescriptor fdesc, EvaluationContext ctx) {
        Object object;
        Descriptors.FieldDescriptor.JavaType javaType = fdesc.getJavaType();
        if (Descriptors.FieldDescriptor.JavaType.DOUBLE.equals(javaType)) {
            object = BoxesRunTime.boxToDouble((double)this.DWValueToDouble(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.FLOAT.equals(javaType)) {
            object = BoxesRunTime.boxToFloat((float)this.DWValueToFloat(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.LONG.equals(javaType)) {
            object = BoxesRunTime.boxToLong((long)this.DWValueToLong(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.INT.equals(javaType)) {
            object = BoxesRunTime.boxToInteger((int)this.DWValueToInt(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.BOOLEAN.equals(javaType)) {
            object = BoxesRunTime.boxToBoolean((boolean)this.DWValueToBool(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.STRING.equals(javaType)) {
            object = this.DWValueToString(value, ctx);
        } else if (Descriptors.FieldDescriptor.JavaType.MESSAGE.equals(javaType)) {
            object = this.DWValueToMessage(value, fdesc.getMessageType(), ctx);
        } else if (Descriptors.FieldDescriptor.JavaType.BYTE_STRING.equals(javaType)) {
            object = this.DWValueToByteString(value, ctx);
        } else if (Descriptors.FieldDescriptor.JavaType.ENUM.equals(javaType)) {
            object = this.DWValueToEnum(value, fdesc.getEnumType(), ctx);
        } else {
            throw new Exception("Not managed descriptor type");
        }
        return object;
    }

    private double DWValueToDouble(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toDouble();
    }

    private float DWValueToFloat(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toFloat();
    }

    private long DWValueToLong(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toLong();
    }

    private int DWValueToInt(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toInt();
    }

    /*
     * WARNING - void declaration
     */
    private boolean DWValueToBool(Value<?> value, EvaluationContext ctx) {
        void var3_3;
        if (!BooleanType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Boolean");
        }
        boolean v = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
        return (boolean)var3_3;
    }

    private String DWValueToString(Value<?> value, EvaluationContext ctx) {
        if (!StringType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid String");
        }
        CharSequence v = (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return ((Object)v).toString();
    }

    private ByteString DWValueToByteString(Value<?> value, EvaluationContext ctx) {
        if (!BinaryType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Binary");
        }
        return ByteString.readFrom((InputStream)((InputStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx)));
    }

    private Descriptors.EnumValueDescriptor DWValueToEnum(Value<?> value, Descriptors.EnumDescriptor edesc, EvaluationContext ctx) {
        if (!StringType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid String");
        }
        CharSequence v = (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return edesc.findValueByName(((Object)v).toString());
    }

    public Message DWValueToMessage(Value<?> value, Descriptors.Descriptor desc, EvaluationContext ctx) {
        if (!ObjectType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Object");
        }
        ObjectSeq objectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        DynamicMessage.Builder b = DynamicMessage.newBuilder((Descriptors.Descriptor)desc);
        objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)f -> {
            String name = ((QualifiedName)f._1().evaluate(ctx)).name();
            Descriptors.FieldDescriptor fdesc = desc.findFieldByName(name);
            return fdesc.isRepeated() ? b.addRepeatedField(fdesc, MODULE$.DWValueToProto(f._2(), fdesc, ctx)) : b.setField(fdesc, MODULE$.DWValueToProto(f._2(), fdesc, ctx));
        });
        return b.build();
    }

    private Converter$() {
        MODULE$ = this;
    }
}

