/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.protobuf.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.BinaryValue;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.KeyValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.NumberValue;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValueBuilder;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Converter$ {
    public static Converter$ MODULE$;
    private final Regex unknownFieldRegex;

    static {
        new Converter$();
    }

    /*
     * WARNING - void declaration
     */
    public ObjectValueBuilder unknownFieldSetToDWValue(UnknownFieldSet unks) {
        void var2_2;
        ObjectValueBuilder builder = new ObjectValueBuilder();
        unks.asMap().forEach((idx, field) -> {
            KeyValue key = KeyValue$.MODULE$.apply(new QualifiedName(new StringBuilder(1).append("_").append(idx).toString(), (Option)None$.MODULE$), (Option)None$.MODULE$);
            field.getGroupList().forEach(unks -> builder.addPair(key, (Value)MODULE$.unknownFieldSetToDWValue((UnknownFieldSet)unks).build()));
            field.getVarintList().forEach(n -> builder.addPair(key, (Value)NumberValue$.MODULE$.apply(Predef$.MODULE$.Long2long(n))));
            field.getFixed32List().forEach(n -> builder.addPair(key, (Value)NumberValue$.MODULE$.apply(Predef$.MODULE$.Integer2int(n))));
            field.getFixed64List().forEach(n -> builder.addPair(key, (Value)NumberValue$.MODULE$.apply(Predef$.MODULE$.Long2long(n))));
            field.getLengthDelimitedList().forEach(bs -> builder.addPair(key, (Value)BinaryValue$.MODULE$.apply(bs.toByteArray())));
        });
        return var2_2;
    }

    public ObjectValue protoMessageToDWValue(Message msg) {
        Descriptors.Descriptor desc = msg.getDescriptorForType();
        Buffer fields = JavaConverters$.MODULE$.asScalaBuffer(desc.getFields());
        ObjectValueBuilder builder = new ObjectValueBuilder();
        fields.foreach((Function1 & Serializable & scala.Serializable)fd -> {
            Object object;
            String n = fd.getName();
            Object value = msg.getField(fd);
            if (fd.isRepeated()) {
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((List)value)).asScala()).foreach((Function1 & Serializable & scala.Serializable)f -> builder.addPair(n, MODULE$.protoToDWValue(f, (Descriptors.FieldDescriptor)fd)));
                object = BoxedUnit.UNIT;
            } else {
                object = msg.hasField(fd) || fd.getContainingOneof() == null ? builder.addPair(n, MODULE$.protoToDWValue(value, (Descriptors.FieldDescriptor)fd)) : BoxedUnit.UNIT;
            }
            return object;
        });
        builder.mergeFrom(this.unknownFieldSetToDWValue(msg.getUnknownFields()));
        return builder.build();
    }

    private Value<?> protoToDWValue(Object value, Descriptors.FieldDescriptor fd) {
        Object object;
        if (value instanceof Double) {
            object = NumberValue$.MODULE$.safe(BoxesRunTime.unboxToDouble((Object)value));
        } else if (value instanceof Float) {
            object = NumberValue$.MODULE$.safe((double)BoxesRunTime.unboxToFloat((Object)value));
        } else if (value instanceof Long) {
            object = NumberValue$.MODULE$.safe((double)BoxesRunTime.unboxToLong((Object)value));
        } else if (value instanceof Integer) {
            object = NumberValue$.MODULE$.safe((double)BoxesRunTime.unboxToInt((Object)value));
        } else if (value instanceof Boolean) {
            object = BooleanValue$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)value), BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3());
        } else if (value instanceof Message) {
            object = this.protoMessageToDWValue((Message)value);
        } else if (value instanceof ByteString) {
            object = BinaryValue$.MODULE$.apply(((ByteString)value).toByteArray());
        } else if (value instanceof String) {
            object = StringValue$.MODULE$.apply((String)value);
        } else if (value instanceof Descriptors.EnumValueDescriptor) {
            Descriptors.EnumValueDescriptor enumValue = (Descriptors.EnumValueDescriptor)value;
            object = enumValue.getIndex() == -1 ? NumberValue$.MODULE$.apply(enumValue.getNumber()) : StringValue$.MODULE$.apply(enumValue.getName());
        } else {
            throw new Exception("Not supported proto value");
        }
        return object;
    }

    private Object DWValueToProto(Value<?> value, Descriptors.FieldDescriptor fdesc, EvaluationContext ctx) {
        Object object;
        Descriptors.FieldDescriptor.JavaType javaType = fdesc.getJavaType();
        if (Descriptors.FieldDescriptor.JavaType.DOUBLE.equals(javaType)) {
            object = BoxesRunTime.boxToDouble((double)this.DWValueToDouble(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.FLOAT.equals(javaType)) {
            object = BoxesRunTime.boxToFloat((float)this.DWValueToFloat(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.LONG.equals(javaType)) {
            object = BoxesRunTime.boxToLong((long)this.DWValueToLong(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.INT.equals(javaType)) {
            object = BoxesRunTime.boxToInteger((int)this.DWValueToInt(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.BOOLEAN.equals(javaType)) {
            object = BoxesRunTime.boxToBoolean((boolean)this.DWValueToBool(value, ctx));
        } else if (Descriptors.FieldDescriptor.JavaType.STRING.equals(javaType)) {
            object = this.DWValueToString(value, ctx);
        } else if (Descriptors.FieldDescriptor.JavaType.MESSAGE.equals(javaType)) {
            object = this.DWValueToMessage(value, fdesc.getMessageType(), ctx);
        } else if (Descriptors.FieldDescriptor.JavaType.BYTE_STRING.equals(javaType)) {
            object = this.DWValueToByteString(value, ctx);
        } else if (Descriptors.FieldDescriptor.JavaType.ENUM.equals(javaType)) {
            object = this.DWValueToEnum(value, fdesc.getEnumType(), ctx);
        } else {
            throw new Exception("Not managed descriptor type");
        }
        return object;
    }

    private double DWValueToDouble(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toDouble();
    }

    private float DWValueToFloat(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toFloat();
    }

    private long DWValueToLong(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toLong();
    }

    private int DWValueToInt(Value<?> value, EvaluationContext ctx) {
        if (!NumberType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Number");
        }
        Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return v.toInt();
    }

    /*
     * WARNING - void declaration
     */
    private boolean DWValueToBool(Value<?> value, EvaluationContext ctx) {
        void var3_3;
        if (!BooleanType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Boolean");
        }
        boolean v = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
        return (boolean)var3_3;
    }

    private String DWValueToString(Value<?> value, EvaluationContext ctx) {
        if (!StringType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid String");
        }
        CharSequence v = (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        return ((Object)v).toString();
    }

    private ByteString DWValueToByteString(Value<?> value, EvaluationContext ctx) {
        if (!BinaryType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Binary");
        }
        return ByteString.readFrom((InputStream)((InputStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx)));
    }

    private Descriptors.EnumValueDescriptor DWValueToEnum(Value<?> value, Descriptors.EnumDescriptor edesc, EvaluationContext ctx) {
        Descriptors.EnumValueDescriptor enumValueDescriptor;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            CharSequence v = (CharSequence)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            enumValueDescriptor = edesc.findValueByName(((Object)v).toString());
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number v = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            enumValueDescriptor = edesc.findValueByNumberCreatingIfUnknown(v.toInt());
        } else {
            throw new Exception("value is not a valid String");
        }
        return enumValueDescriptor;
    }

    public UnknownFieldSet.Field DWValueToUnknown(Value<?> value, EvaluationContext ctx) {
        UnknownFieldSet.Field.Builder builder;
        UnknownFieldSet.Field.Builder builder2 = UnknownFieldSet.Field.newBuilder();
        Value<?> value2 = value;
        if (value2 instanceof NumberValue) {
            NumberValue numberValue = (NumberValue)value2;
            builder = builder2.addVarint(((Number)numberValue.evaluate(ctx)).toLong());
        } else if (value2 instanceof BinaryValue) {
            BinaryValue binaryValue = (BinaryValue)value2;
            builder = builder2.addLengthDelimited(ByteString.readFrom((InputStream)((InputStream)binaryValue.evaluate(ctx))));
        } else {
            throw new Exception("TODO Only numbers and binaries can be set to unknown");
        }
        return builder2.build();
    }

    public Regex unknownFieldRegex() {
        return this.unknownFieldRegex;
    }

    public Message DWValueToMessage(Value<?> value, Descriptors.Descriptor desc, EvaluationContext ctx) {
        if (!ObjectType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("value is not a valid Object");
        }
        ObjectSeq objectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        DynamicMessage.Builder b = DynamicMessage.newBuilder((Descriptors.Descriptor)desc);
        objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)f -> {
            BoxedUnit boxedUnit;
            String name = ((QualifiedName)f._1().evaluate(ctx)).name();
            Descriptors.FieldDescriptor fdesc = desc.findFieldByName(name);
            if (fdesc == null) {
                BoxedUnit boxedUnit2;
                String string = name;
                Option option = MODULE$.unknownFieldRegex().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String index = (String)((LinearSeqOptimized)option.get()).apply(0);
                    boxedUnit2 = b.mergeUnknownFields(UnknownFieldSet.newBuilder().addField(new StringOps(Predef$.MODULE$.augmentString(index)).toInt(), MODULE$.DWValueToUnknown(f._2(), ctx)).build());
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return fdesc != null ? (fdesc.isRepeated() ? b.addRepeatedField(fdesc, MODULE$.DWValueToProto(f._2(), fdesc, ctx)) : b.setField(fdesc, MODULE$.DWValueToProto(f._2(), fdesc, ctx))) : BoxedUnit.UNIT;
        });
        return b.build();
    }

    private Converter$() {
        MODULE$ = this;
        this.unknownFieldRegex = new StringOps(Predef$.MODULE$.augmentString("_(\\d*)")).r();
    }
}

