package org.mule.weave.v2.module.protobuf

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.writer.DeferredWriter
import org.mule.weave.v2.module.writer.TargetProvider
import org.mule.weave.v2.parser.module.MimeType

class ProtoBufDataFormat extends DataFormat[ProtoBufSettings, ProtoBufSettings] {
  override def name(): String = "protobuf"

  override val defaultMimeType: MimeType = new MimeType("application", "protobuf")
  override val acceptedMimeTypes: Seq[MimeType] = Seq(
    new MimeType("application", "protobuf"),
    new MimeType("application", "x-protobuf"))

  override def reader(source: SourceProvider)(implicit ctx: EvaluationContext): Reader =
    new ProtoBufReader(source, createReaderSettings(), ctx)

  override def writer(target: Option[Any], outputMimeType: MimeType)(implicit ctx: EvaluationContext): DeferredWriter[ProtoBufSettings] =
    DeferredWriter(ProtoBufWriter.apply, TargetProvider(target), createWriterSettings())

  override protected def writerSettings(): ProtoBufSettings = new ProtoBufSettings(this)

  override protected def readerSettings(): ProtoBufSettings = new ProtoBufSettings(this)

  override def fileExtensions: Seq[String] = Seq(".protobuf", ".pb")
}

object ProtoBufDataFormat extends ProtoBufDataFormat