package org.mule.weave.v2.module.protobuf

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.protobuf.utils.DWToProtoConverter.DWValueToMessage
import org.mule.weave.v2.module.writer.TargetProvider
import org.mule.weave.v2.module.writer.Writer

import java.io.OutputStream

class ProtoBufWriter(var os: OutputStream, val settings: ProtoBufSettings)(implicit ctx: EvaluationContext) extends Writer {
  override def dataFormat: Option[DataFormat[_, _]] = Some(new ProtoBufDataFormat())

  override protected def doWriteValue(value: Value[_])(implicit ctx: EvaluationContext): Unit = {
    DWValueToMessage(value, settings.messageDescriptor).writeTo(os)
  }

  override def result: Any = os

  override def close(): Unit = os.close()
}

object ProtoBufWriter {
  def apply(tp: TargetProvider, settings: ProtoBufSettings)(implicit ctx: EvaluationContext): ProtoBufWriter = {
    new ProtoBufWriter(tp.asOutputStream, settings)
  }
}
