/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.helper;

import groovy.lang.GroovyShell;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Properties;
import org.mule.weave.v2.io.FileHelper$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.MimeType;
import org.mule.weave.v2.module.csv.DefaultCSVDataFormat$;
import org.mule.weave.v2.module.csv.reader.CSVReader;
import org.mule.weave.v2.module.csv.reader.CSVReader$;
import org.mule.weave.v2.module.csv.reader.parser.CSVReaderSettings;
import org.mule.weave.v2.module.json.reader.JsonReader$;
import org.mule.weave.v2.module.pojo.reader.JavaReader;
import org.mule.weave.v2.module.pojo.writer.JavaWriter;
import org.mule.weave.v2.module.pojo.writer.JavaWriter$;
import org.mule.weave.v2.module.reader.Reader;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider$;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.module.xml.DefaultXmlDataFormat$;
import org.mule.weave.v2.module.xml.reader.DelegatingXmlReader$;
import org.mule.weave.v2.module.xml.reader.XmlReaderSettings;
import org.mule.weave.v2.module.xml.reader.indexed.IndexedXmlReader$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\b\u0010\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQA\u0013\u0001\u0005\u0002-Cq\u0001\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u000fC\u0004}\u0001E\u0005I\u0011A?\t\r}\u0004A\u0011AA\u0001\u0011!\ty\u0001AI\u0001\n\u0003\t\b\u0002CA\t\u0001E\u0005I\u0011A?\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!I\u00111\b\u0001\u0012\u0002\u0013\u0005\u0011QH\u0004\b\u0003\u0003z\u0001\u0012AA\"\r\u0019qq\u0002#\u0001\u0002F!1\u0011\u0005\u0004C\u0001\u0003\u000f\u0012A\"\u00128hS:,\u0007*\u001a7qKJT!\u0001E\t\u0002\r!,G\u000e]3s\u0015\t\u00112#\u0001\u0002we)\u0011A#F\u0001\u0006o\u0016\fg/\u001a\u0006\u0003-]\tA!\\;mK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"A\b\u0002#\u0005$G-\u001b;j_:\fGNR8s[\u0006$8/F\u0001(!\u0011AsFM\u001b\u000f\u0005%j\u0003C\u0001\u0016\u001e\u001b\u0005Y#B\u0001\u0017\u001a\u0003\u0019a$o\\8u}%\u0011a&H\u0001\u0007!J,G-\u001a4\n\u0005A\n$aA'ba*\u0011a&\b\t\u0003QMJ!\u0001N\u0019\u0003\rM#(/\u001b8ha\r1d\b\u0013\t\u0005oibt)D\u00019\u0015\tI\u0014#\u0001\u0004n_\u0012,H.Z\u0005\u0003wa\u0012!\u0002R1uC\u001a{'/\\1u!\tid\b\u0004\u0001\u0005\u0013}\u0012\u0011\u0011!A\u0001\u0006\u0003\u0001%aA0%cE\u0011\u0011\t\u0012\t\u00039\tK!aQ\u000f\u0003\u000f9{G\u000f[5oOB\u0011A$R\u0005\u0003\rv\u00111!\u00118z!\ti\u0004\nB\u0005J\u0005\u0005\u0005\t\u0011!B\u0001\u0001\n\u0019q\f\n\u001a\u0002\u0019\t,\u0018\u000e\u001c3SK\u0006$WM]:\u0015\t1c\u0016n\u001b\u000b\u0003\u001bR\u0003B\u0001K\u00183\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bO\u0001\u0007e\u0016\fG-\u001a:\n\u0005M\u0003&A\u0002*fC\u0012,'\u000fC\u0003V\u0007\u0001\u000fa+A\u0002dib\u0004\"a\u0016.\u000e\u0003aS!!W\t\u0002\u000b5|G-\u001a7\n\u0005mC&!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\")Ql\u0001a\u0001=\u00061\u0011N\u001c9viN\u00042\u0001H0b\u0013\t\u0001WDA\u0003BeJ\f\u0017\u0010\u0005\u0002cO6\t1M\u0003\u0002eK\u0006\u0011\u0011n\u001c\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0003GS2,\u0007b\u00026\u0004!\u0003\u0005\rAM\u0001\u0010I\u00164\u0017-\u001e7u\u000b:\u001cw\u000eZ5oO\"9An\u0001I\u0001\u0002\u0004i\u0017\u0001\u00044pe\u000e,\u0017J\u001c3fq\u0016$\u0007C\u0001\u000fo\u0013\tyWDA\u0004C_>dW-\u00198\u0002-\t,\u0018\u000e\u001c3SK\u0006$WM]:%I\u00164\u0017-\u001e7uII*\u0012A\u001d\u0016\u0003eM\\\u0013\u0001\u001e\t\u0003kjl\u0011A\u001e\u0006\u0003ob\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005el\u0012AC1o]>$\u0018\r^5p]&\u00111P\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00062vS2$'+Z1eKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003yT#!\\:\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\t\u0003\u0007\t9!a\u0003\u0002\u000eQ\u0019a*!\u0002\t\u000bU3\u00019\u0001,\t\r\u0005%a\u00011\u0001b\u0003\u00111\u0017\u000e\\3\t\u000f)4\u0001\u0013!a\u0001e!9AN\u0002I\u0001\u0002\u0004i\u0017!\u00062vS2$'+Z1eKJ$C-\u001a4bk2$HEM\u0001\u0016EVLG\u000e\u001a*fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011W/\u001b7e/JLG/\u001a:\u0015\r\u0005]\u0011qEA\u0016)\u0011\tI\"!\n\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b9\u0003\u00199(/\u001b;fe&!\u00111EA\u000f\u0005\u00199&/\u001b;fe\")Q+\u0003a\u0002-\"1\u0011\u0011F\u0005A\u0002I\nqb\\;uaV$X\t\u001f;f]NLwN\u001c\u0005\n\u0003[I\u0001\u0013!a\u0001\u0003_\tab\\;uaV$X*[7f)f\u0004X\rE\u0003\u001d\u0003c\t)$C\u0002\u00024u\u0011aa\u00149uS>t\u0007cA\u001c\u00028%\u0019\u0011\u0011\b\u001d\u0003\u00115KW.\u001a+za\u0016\fQCY;jY\u0012<&/\u001b;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002@)\u001a\u0011qF:\u0002\u0019\u0015sw-\u001b8f\u0011\u0016d\u0007/\u001a:\u0011\u0005\u0011b1C\u0001\u0007$)\t\t\u0019\u0005")
public class EngineHelper {
    public Map<String, DataFormat<?, ?>> additionalFormats() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<String, Reader> buildReaders(File[] inputs, String defaultEncoding, boolean forceIndexed, EvaluationContext ctx) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).map((Function1 & Serializable & scala.Serializable)file -> {
            Reader reader = this.buildReader((File)file, defaultEncoding, forceIndexed, ctx);
            return new Tuple2((Object)FileHelper$.MODULE$.baseName(file), (Object)reader);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public Reader buildReader(File file, String defaultEncoding, boolean forceIndexed, EvaluationContext ctx) {
        CSVReader cSVReader;
        String extension = (String)new StringOps(Predef$.MODULE$.augmentString(file.getName())).drop(file.getName().lastIndexOf(46));
        File configuration = new File(file.getParentFile(), new StringBuilder(18).append(FileHelper$.MODULE$.baseName(file)).append("-config.properties").toString());
        Properties configurationProperties = new Properties();
        if (configuration.exists()) {
            FileInputStream stream = new FileInputStream(configuration);
            configurationProperties.load(stream);
            stream.close();
        }
        String encoding = configurationProperties.getProperty("encoding", defaultEncoding);
        String string = extension;
        if (".xml".equals(string)) {
            XmlReaderSettings settings = (XmlReaderSettings)DefaultXmlDataFormat$.MODULE$.createReaderSettings();
            settings.indexedReader_$eq(forceIndexed);
            cSVReader = forceIndexed ? IndexedXmlReader$.MODULE$.apply((InputStream)new FileInputStream(file), encoding, settings, ctx) : DelegatingXmlReader$.MODULE$.apply((InputStream)new FileInputStream(file), encoding, settings, ctx);
        } else if (".csv".equals(string)) {
            cSVReader = forceIndexed ? CSVReader$.MODULE$.apply(file, encoding, (CSVReaderSettings)DefaultCSVDataFormat$.MODULE$.createReaderSettings(), true, ctx) : CSVReader$.MODULE$.apply((InputStream)new FileInputStream(file), encoding, (CSVReaderSettings)DefaultCSVDataFormat$.MODULE$.createReaderSettings(), ctx);
        } else if (".groovy".equals(string)) {
            cSVReader = new JavaReader(new GroovyShell().evaluate(file), ctx);
        } else if (".json".equals(string)) {
            cSVReader = JsonReader$.MODULE$.apply((InputStream)new FileInputStream(file), encoding, forceIndexed, ctx);
        } else {
            Option maybeFormat = DataFormatManager$.MODULE$.byExtension(extension, ctx);
            DataFormat format = (DataFormat)maybeFormat.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(38).append("Unable to find reader for extension `").append(extension).append("`").toString());
            });
            SourceProvider provider = SourceProvider$.MODULE$.apply(file, Charset.forName(encoding), format.defaultMimeType());
            cSVReader = format.reader(provider, ctx);
        }
        CSVReader reader = cSVReader;
        return reader;
    }

    public String buildReaders$default$2() {
        return "UTF-8";
    }

    public boolean buildReaders$default$3() {
        return false;
    }

    public String buildReader$default$2() {
        return "UTF-8";
    }

    public boolean buildReader$default$3() {
        return false;
    }

    public Writer buildWriter(String outputExtension, Option<MimeType> outputMimeType, EvaluationContext ctx) {
        JavaWriter javaWriter;
        String string = outputExtension;
        if (".groovy".equals(string)) {
            javaWriter = JavaWriter$.MODULE$.apply(Thread.currentThread().getContextClassLoader());
        } else {
            Option maybeFormat = DataFormatManager$.MODULE$.byExtension(outputExtension, ctx);
            DataFormat format = (DataFormat)maybeFormat.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(38).append("Unable to find writer for extension `").append(outputExtension).append("`").toString());
            });
            javaWriter = format.writer((Option)None$.MODULE$, (MimeType)outputMimeType.getOrElse((Function0 & Serializable & scala.Serializable)() -> format.defaultMimeType()), ctx);
        }
        return javaWriter;
    }

    public Option<MimeType> buildWriter$default$2() {
        return None$.MODULE$;
    }
}

