package org.mule.weave.v2.helper

import org.mule.weave.v2.model.service.DefaultLanguageLevelService
import org.mule.weave.v2.model.service.DefaultSettingsService
import org.mule.weave.v2.model.service.LanguageLevelService
import org.mule.weave.v2.model.service.PropertiesSettings
import org.mule.weave.v2.model.service.SettingsService
import org.mule.weave.v2.model.service.SimpleSettingsService
import org.mule.weave.v2.model.service.WeaveLanguageLevelService
import org.mule.weave.v2.utils.DataWeaveVersion

import java.io.File
import java.io.FileInputStream
import java.util.Properties

trait ConfigPropertyAwareTest {

  def createSettingsService(configProperty: Option[File], languageLevelService: LanguageLevelService, mayBeProps: Option[Properties] = None): SettingsService = {
    if (configProperty.isDefined) {
      val fis = new FileInputStream(configProperty.get)
      try {
        val properties = mayBeProps.getOrElse(new Properties())
        properties.load(fis)
        SimpleSettingsService(PropertiesSettings(properties), languageLevelService)
      } finally {
        fis.close()
      }
    } else {
      if (mayBeProps.isDefined) {
        SimpleSettingsService(mayBeProps.get)
      } else {
        DefaultSettingsService
      }
    }
  }

  def createLanguageLevelService(configProperty: Option[File]): LanguageLevelService = {
    if (configProperty.isDefined) {
      val fis = new FileInputStream(configProperty.get)
      try {
        val properties = new Properties()
        properties.load(fis)
        val languageLevel = properties.getProperty("languageLevel", null)
        if (languageLevel == null) {
          DefaultLanguageLevelService
        } else {
          val version = languageLevel.split('.')
          val dwVersion = DataWeaveVersion(version(0).toInt, version(1).toInt)
          WeaveLanguageLevelService(dwVersion)
        }
      } finally {
        fis.close()
      }
    } else {
      DefaultLanguageLevelService
    }
  }

}
