package org.mule.weave.v2.helper

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormatManager
import org.mule.weave.v2.module.pojo.writer.JavaWriter
import org.mule.weave.v2.module.writer.Writer
import org.mule.weave.v2.parser.module.MimeType

trait WriteCapableTest {
  def buildWriter(outputExtension: String, outputMimeType: Option[MimeType] = None)(implicit ctx: EvaluationContext): Writer = {
    outputExtension match {
      case ".groovy" => JavaWriter(Thread.currentThread().getContextClassLoader)
      case _ =>
        val maybeFormat = DataFormatManager.byExtension(outputExtension)
        val format = maybeFormat.getOrElse(throw new IllegalArgumentException("Unable to find writer for extension `" + outputExtension + "`"))
        format.writer(None, outputMimeType.getOrElse(format.defaultMimeType))
    }
  }

}

object WriteCapableTest extends WriteCapableTest