in0 map {
  index: $.index,
  isActive: $.isActive,
  name: $.firstName ++ " " ++ $.lastName,
  age: $.age as Number,
  gender: $.gender,
  company: lower($.company),
  email: $.email,
  phone: using (phone = $.phone match /\+(\d+)\s\((\d+)\)\s(\d+\-\d+)/) {
    countryCode: phone[1] as Number,
    areaCode: phone[2] as Number,
    number: phone[3]
  },
  address: using (address = $.address splitBy ", ") {
    street: address[0],
    city: address[1],
    state: address[2],
    zipCode: address[3] as Number
  },
  tags: $.tags
                map
                    upper($),
  friends: {
    female: $.friends filter ($.gender == "female") map {
      id: $.id,
      name: $.name
    },
    male: $.friends filter ($.gender == "male") map {
      id: $.id,
      name: $.name
    },
    total: sizeOf($.friends)
  }

}