
import fail from dw::Runtime
import dw::Crypto

fun assert(a, b, message: String = ''): Boolean =
  if (a == b)
    true
  else
    using(
      x = fail(
'$message
  "$(a default 'Null')" ($(typeOf(a))) did not match
  "$(b default 'Null')" ($(typeOf(b)))')
    )
      false

fun test(list: Array<Boolean>): Boolean = list reduce ($ and $$) default true
---
test([
  assert(
    Crypto::MD5("asd"),
    "7815696ecbf1c96e6894b779456d330e",
    'String MD5'
  ),
  assert(
    Crypto::SHA1("dsasd"),
    "2fa183839c954e6366c206367c9be5864e4f4a65",
    'String SHA1'
  ),
  assert(
    Crypto::MD5("asd" as Binary),
    "7815696ecbf1c96e6894b779456d330e",
    'Binary MD5'
  ),
  assert(
    Crypto::SHA1("dsasd" as Binary) ,
    "2fa183839c954e6366c206367c9be5864e4f4a65",
    'Binary SHA1'
  ),
  assert(
    Crypto::HMACWith("key_re_loca", "xxxxx") ,
    "2e2da2e51286db8afa9900f51218529cda3dd32a",
    'HMAC'
  )
])
