package org.mule.weave.v2.interpreted.node.executors

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.Frame
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class EmptyFunctionExecutor(
  val node: ValueNode[_],
  val name: String,
  override val showInStacktrace: Boolean = false,
  override val location: WeaveLocation) extends EmptyExecutor with Product2[ValueNode[_], String] {
  override def executeEmpty()(implicit ctx: ExecutionContext): Value[Any] = {
    val activeFrame: Frame = ctx.executionStack().activeFrame()
    try {
      activeFrame.updateCallSite(node)
      node.execute.asInstanceOf[FunctionValue].call()
    } catch {
      case ex: ExecutionException =>
        if (showInStacktrace) {
          ex.addCallToStacktrace(location, name())
        }
        throw ex
    } finally {
      activeFrame.cleanCallSite()
    }
  }

  override def _1: ValueNode[_] = node

  override def _2: String = name

  override def execute(arguments: Array[Value[_]])(implicit ctx: ExecutionContext): Value[Any] = {
    executeEmpty()
  }

  override def name()(implicit ctx: ExecutionContext): String = {
    this.name
  }
}
