package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.exception.InvalidSelectionException
import org.mule.weave.v2.core.exception.KeyNotFoundException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.structure.NameSeq
import org.mule.weave.v2.model.structure.NameValuePair
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.NameType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.helper.AttributeHelper
import org.mule.weave.v2.parser.location.WeaveLocation

class AttributeValueSelectorOperator(override val location: WeaveLocation, staticSelection: Boolean) extends BinaryFunctionValue {

  private val delegate = ArrayNameValueSelectorOperator(location, staticSelection)

  override val L = AnyType

  override val R = NameType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    leftValue match {
      case v if ArrayType.accepts(v) => {
        val array: ArraySeq = ArrayType.coerce(leftValue).evaluate
        val attributes = array
          .toIterator()
          .flatMap((v: Value[_]) => {
            AttributeHelper.attributesAsObject(v)
          })
        delegate.doExecute(ArrayValue(attributes, this), rightValue)
      }
      case _ => {
        val result: Option[Value[NameSeq]] = AttributeHelper.attributes(leftValue)
        if (result.isDefined) {
          val selectionResult: Option[NameValuePair] = result.get.evaluate.keyValueOf(rightValue)
          if (selectionResult.isDefined) {
            selectionResult.get._2
          } else {
            throw InvalidSelectionException(new KeyNotFoundException(this, rightValue.evaluate))
          }
        } else {
          throw InvalidSelectionException(new KeyNotFoundException(this, rightValue.evaluate))
        }
      }
    }
  }
}

