package org.mule.weave.v2.runtime.core.functions.types

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.SchemaValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

object MetadataOfFunction extends UnaryFunctionValue {
  override val R = TypeType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    v.evaluate.schema match {
      case Some(schema) => ObjectType.coerce(SchemaValue(schema))
      case _            => ObjectValue.empty
    }
  }
}
