package org.mule.weave.v2.runtime.core.operator.relational

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class NumberNumberLessOrEqualThanOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  override val L = NumberType

  override val R = NumberType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(leftValue.evaluate.<=(rightValue.evaluate), this)
  }
}

class LessOrEqualThanOperator(override val location: WeaveLocation) extends BaseRelationalOperator {

  protected def doCompare(leftValue: Value[_], rightValue: Value[_])(implicit ctx: EvaluationContext): BooleanValue = {
    BooleanValue(leftValue.compareTo(rightValue) <= 0, this)
  }

}
