package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.exception.InvalidIfConditionException
import org.mule.weave.v2.model.values.Value

class IfNode(val expression: ValueNode[_], val condition: ValueNode[_], val elseExpr: ValueNode[_]) extends ValueNode[Any] with Product3[ValueNode[_], ValueNode[_], ValueNode[_]] {
  override def doExecute(implicit executionContext: ExecutionContext): Value[_] = {
    val value: Value[_] = condition.execute
    if ((value.evaluate == true) || (value.evaluate == "true")) {
      expression.execute
    } else if ((value.evaluate == false) || (value.evaluate == "false")) {
      elseExpr.execute
    } else {
      throw new InvalidIfConditionException(value, condition.location())
    }
  }

  override def _1: ValueNode[_] = expression

  override def _2: ValueNode[_] = condition

  override def _3: ValueNode[_] = elseExpr
}

object IfNode {
  def apply(expression: ValueNode[_], condition: ValueNode[_], elseExpr: ValueNode[_]): ValueNode[_] = new IfNode(expression, condition, elseExpr)
}
