package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values._
object StringParseUrlFunctionValue extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    var kvSeq: Seq[KeyValuePair] = Seq(KeyValuePair(KeyValue("isValid"), BooleanValue(value = false)))
    val rawURI = v.evaluate.toString
    kvSeq :+= KeyValuePair(KeyValue("raw"), StringValue(rawURI))

    try {
      val uri = java.net.URI.create(rawURI)
      kvSeq = Seq(KeyValuePair(KeyValue("isValid"), BooleanValue(value = true)))
      kvSeq :+= KeyValuePair(KeyValue("raw"), StringValue(rawURI))

      if (uri.getHost != null)
        kvSeq :+= KeyValuePair(KeyValue("host"), StringValue(uri.getHost))

      if (uri.getAuthority != null)
        kvSeq :+= KeyValuePair(KeyValue("authority"), StringValue(uri.getAuthority))

      if (uri.getFragment != null)
        kvSeq :+= KeyValuePair(KeyValue("fragment"), StringValue(uri.getFragment))

      if (uri.getPath != null)
        kvSeq :+= KeyValuePair(KeyValue("path"), StringValue(uri.getPath))

      if (uri.getPort != -1)
        kvSeq :+= KeyValuePair(KeyValue("port"), NumberValue(uri.getPort))

      if (uri.getQuery != null)
        kvSeq :+= KeyValuePair(KeyValue("query"), StringValue(uri.getQuery))

      if (uri.getScheme != null)
        kvSeq :+= KeyValuePair(KeyValue("scheme"), StringValue(uri.getScheme))

      if (uri.getUserInfo != null)
        kvSeq :+= KeyValuePair(KeyValue("user"), StringValue(uri.getUserInfo))

      kvSeq :+= KeyValuePair(KeyValue("isAbsolute"), BooleanValue(uri.isAbsolute))
      kvSeq :+= KeyValuePair(KeyValue("isOpaque"), BooleanValue(uri.isOpaque))

      ObjectValue(kvSeq, UnknownLocationCapable)
    } catch {
      case _: IllegalArgumentException => {
        ObjectValue(kvSeq, UnknownLocationCapable)
      }
    }
  }
}

object ParseUrlFunctionValue {
  val value = Seq(StringParseUrlFunctionValue)
}
