package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.DoBlockNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class DoBlockNodeMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case dbn: DoBlockNode =>
        if (!dbn.isAnnotatedWith(classOf[DoBlockNodeNonShadowedVariablesAnnotation])) {
          val maybeScope = scope.scopeOf(dbn.body)
          if (maybeScope.exists(_.shadowedVariables().isEmpty)) {
            dbn.annotate(new DoBlockNodeNonShadowedVariablesAnnotation())
          }
        }
      case _ =>
      // Nothing to do
    }
  }
}

class DoBlockNodeNonShadowedVariablesAnnotation extends AstNodeAnnotation {

  override def name(): String = {
    "DoBlockNodeNonShadowedVariables"
  }
}
