package org.mule.weave.v2.compilation.mapper

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NoneSerializableValueAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.compilation.exception.DeserializationException
import org.mule.weave.v2.compilation.exception.SerializationException
import org.mule.weave.v2.compilation.mapper.ast.AndNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AnnotationArgumentNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AnnotationArgumentsNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AnnotationDirectiveNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AnnotationNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AnnotationParameterNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AnnotationParametersNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ArrayIndexUpdateSelectorNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ArrayNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AstNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AttributeNameUpdateSelectorNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.AttributesNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.BinaryOpNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.BooleanNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ConditionalNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ContentTypeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DataFormatIdSerializer
import org.mule.weave.v2.compilation.mapper.ast.DateTimeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DeconstructArrayPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DeconstructObjectPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DefaultNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DefaultPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DirectiveOptionNameSerializer
import org.mule.weave.v2.compilation.mapper.ast.DirectiveOptionSerializer
import org.mule.weave.v2.compilation.mapper.ast.DoBlockNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DocumentNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DynamicKeyNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DynamicNameNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.DynamicReturnTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.EmptyArrayPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.EmptyObjectPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ExistsSelectorNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ExpressionPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.FieldNameUpdateSelectorNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionCallNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionCallParametersNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionDirectiveNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionParameterSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionParameterTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionParametersSerializer
import org.mule.weave.v2.compilation.mapper.ast.FunctionTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.HeadTailArrayNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.HeadTailObjectNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.HeaderNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.IfNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ImportDirectiveSerializer
import org.mule.weave.v2.compilation.mapper.ast.ImportedElementSerializer
import org.mule.weave.v2.compilation.mapper.ast.ImportedElementsSerializer
import org.mule.weave.v2.compilation.mapper.ast.InputDirectiveSerializer
import org.mule.weave.v2.compilation.mapper.ast.IntersectionTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.KeyNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.KeyTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.KeyValuePairNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.KeyValueTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.LiteralPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.LiteralTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.LocalDateNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.LocalDateTimeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.LocalTimeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ModuleNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.MultiFieldNameUpdateSelectorNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameValuePairNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NameValueTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NamespaceDirectiveSerializer
import org.mule.weave.v2.compilation.mapper.ast.NamespaceNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NativeTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NullNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NullSafeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NullUnSafeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.NumberNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ObjectNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.ObjectTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.OrNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.OutputDirectiveSerializer
import org.mule.weave.v2.compilation.mapper.ast.OverloadedFunctionNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.PatternExpressionsNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.PatternMatcherNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.PeriodNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.RegexNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.RegexPatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.SchemaNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.SchemaPropertyNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.StringInterpolationNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.StringNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TimeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TimeZoneNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TypeDirectiveSerializer
import org.mule.weave.v2.compilation.mapper.ast.TypeParameterNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TypeParametersApplicationListNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TypeParametersListNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TypePatternNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TypeReferenceNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.TypeSelectorNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UnaryOpNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UndefinedExpressionNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UnionTypeNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UnlessNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UpdateExpressionNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UpdateExpressionsNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UpdateNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UriNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UsingNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.UsingVariableAssignmentSerializer
import org.mule.weave.v2.compilation.mapper.ast.UsingVariableAssignmentsSerializer
import org.mule.weave.v2.compilation.mapper.ast.VarDirectiveSerializer
import org.mule.weave.v2.compilation.mapper.ast.VariableReferenceNodeSerializer
import org.mule.weave.v2.compilation.mapper.ast.VersionDirectiveSerializer
import org.mule.weave.v2.compilation.mapper.ast.VersionMajorSerializer
import org.mule.weave.v2.compilation.mapper.ast.VersionMinorSerializer
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.UndefinedExpressionNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentsNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.conditional.DefaultNode
import org.mule.weave.v2.parser.ast.conditional.IfNode
import org.mule.weave.v2.parser.ast.conditional.UnlessNode
import org.mule.weave.v2.parser.ast.functions.DoBlockNode
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.functions.FunctionParameter
import org.mule.weave.v2.parser.ast.functions.FunctionParameters
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode
import org.mule.weave.v2.parser.ast.functions.UsingNode
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignment
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignments
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.AnnotationParameterNode
import org.mule.weave.v2.parser.ast.header.directives.AnnotationParametersNode
import org.mule.weave.v2.parser.ast.header.directives.ContentType
import org.mule.weave.v2.parser.ast.header.directives.DataFormatId
import org.mule.weave.v2.parser.ast.header.directives.DirectiveOption
import org.mule.weave.v2.parser.ast.header.directives.DirectiveOptionName
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.header.directives.ImportedElement
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective
import org.mule.weave.v2.parser.ast.header.directives.OutputDirective
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective
import org.mule.weave.v2.parser.ast.header.directives.VersionMajor
import org.mule.weave.v2.parser.ast.header.directives.VersionMinor
import org.mule.weave.v2.parser.ast.logical.AndNode
import org.mule.weave.v2.parser.ast.logical.OrNode
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.operators.UnaryOpNode
import org.mule.weave.v2.parser.ast.patterns.DeconstructArrayPatternNode
import org.mule.weave.v2.parser.ast.patterns.DeconstructObjectPatternNode
import org.mule.weave.v2.parser.ast.patterns.DefaultPatternNode
import org.mule.weave.v2.parser.ast.patterns.EmptyArrayPatternNode
import org.mule.weave.v2.parser.ast.patterns.EmptyObjectPatternNode
import org.mule.weave.v2.parser.ast.patterns.ExpressionPatternNode
import org.mule.weave.v2.parser.ast.patterns.LiteralPatternNode
import org.mule.weave.v2.parser.ast.patterns.PatternExpressionsNode
import org.mule.weave.v2.parser.ast.patterns.PatternMatcherNode
import org.mule.weave.v2.parser.ast.patterns.RegexPatternNode
import org.mule.weave.v2.parser.ast.patterns.TypePatternNode
import org.mule.weave.v2.parser.ast.selectors.ExistsSelectorNode
import org.mule.weave.v2.parser.ast.selectors.NullSafeNode
import org.mule.weave.v2.parser.ast.selectors.NullUnSafeNode
import org.mule.weave.v2.parser.ast.structure.ArrayNode
import org.mule.weave.v2.parser.ast.structure.AttributesNode
import org.mule.weave.v2.parser.ast.structure.BooleanNode
import org.mule.weave.v2.parser.ast.structure.ConditionalNode
import org.mule.weave.v2.parser.ast.structure.DateTimeNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.structure.DynamicKeyNode
import org.mule.weave.v2.parser.ast.structure.DynamicNameNode
import org.mule.weave.v2.parser.ast.structure.HeadTailArrayNode
import org.mule.weave.v2.parser.ast.structure.HeadTailObjectNode
import org.mule.weave.v2.parser.ast.structure.KeyNode
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode
import org.mule.weave.v2.parser.ast.structure.LocalDateNode
import org.mule.weave.v2.parser.ast.structure.LocalDateTimeNode
import org.mule.weave.v2.parser.ast.structure.LocalTimeNode
import org.mule.weave.v2.parser.ast.structure.NameNode
import org.mule.weave.v2.parser.ast.structure.NameValuePairNode
import org.mule.weave.v2.parser.ast.structure.NamespaceNode
import org.mule.weave.v2.parser.ast.structure.NullNode
import org.mule.weave.v2.parser.ast.structure.NumberNode
import org.mule.weave.v2.parser.ast.structure.ObjectNode
import org.mule.weave.v2.parser.ast.structure.PeriodNode
import org.mule.weave.v2.parser.ast.structure.RegexNode
import org.mule.weave.v2.parser.ast.structure.StringInterpolationNode
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.structure.TimeNode
import org.mule.weave.v2.parser.ast.structure.TimeZoneNode
import org.mule.weave.v2.parser.ast.structure.UriNode
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode
import org.mule.weave.v2.parser.ast.structure.schema.SchemaPropertyNode
import org.mule.weave.v2.parser.ast.types.DynamicReturnTypeNode
import org.mule.weave.v2.parser.ast.types.FunctionParameterTypeNode
import org.mule.weave.v2.parser.ast.types.FunctionTypeNode
import org.mule.weave.v2.parser.ast.types.IntersectionTypeNode
import org.mule.weave.v2.parser.ast.types.KeyTypeNode
import org.mule.weave.v2.parser.ast.types.KeyValueTypeNode
import org.mule.weave.v2.parser.ast.types.LiteralTypeNode
import org.mule.weave.v2.parser.ast.types.NameTypeNode
import org.mule.weave.v2.parser.ast.types.NameValueTypeNode
import org.mule.weave.v2.parser.ast.types.NativeTypeNode
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode
import org.mule.weave.v2.parser.ast.types.TypeParameterNode
import org.mule.weave.v2.parser.ast.types.TypeParametersApplicationListNode
import org.mule.weave.v2.parser.ast.types.TypeParametersListNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.types.TypeSelectorNode
import org.mule.weave.v2.parser.ast.types.UnionTypeNode
import org.mule.weave.v2.parser.ast.updates.ArrayIndexUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.AttributeNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.FieldNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.MultiFieldNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionNode
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionsNode
import org.mule.weave.v2.parser.ast.updates.UpdateNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.sdk.WeaveResource

object AstToSerializableMapper extends DWSerializer[AstNode] {

  override def serialize(node: AstNode): SerializableAstNode = {
    node match {
      case n: DocumentNode                      => DocumentNodeSerializer.serialize(n)
      //VALUE WRAPPERS
      case n: BooleanNode                       => BooleanNodeSerializer.serialize(n)
      case n: DateTimeNode                      => DateTimeNodeSerializer.serialize(n)
      case n: LocalDateNode                     => LocalDateNodeSerializer.serialize(n)
      case n: LocalDateTimeNode                 => LocalDateTimeNodeSerializer.serialize(n)
      case n: LocalTimeNode                     => LocalTimeNodeSerializer.serialize(n)
      case n: NullNode                          => NullNodeSerializer.serialize(n)
      case n: NumberNode                        => NumberNodeSerializer.serialize(n)
      case n: PeriodNode                        => PeriodNodeSerializer.serialize(n)
      case n: RegexNode                         => RegexNodeSerializer.serialize(n)
      case n: StringNode                        => StringNodeSerializer.serialize(n)
      case n: TimeNode                          => TimeNodeSerializer.serialize(n)
      case n: TimeZoneNode                      => TimeZoneNodeSerializer.serialize(n)
      case n: UriNode                           => UriNodeSerializer.serialize(n)
      case n: ArrayNode                         => ArrayNodeSerializer.serialize(n)
      case n: ObjectNode                        => ObjectNodeSerializer.serialize(n)
      case n: KeyValuePairNode                  => KeyValuePairNodeSerializer.serialize(n)
      case n: KeyNode                           => KeyNodeSerializer.serialize(n)
      case n: NameNode                          => NameNodeSerializer.serialize(n)
      //OPERATORS
      case n: UnaryOpNode                       => UnaryOpNodeSerializer.serialize(n)
      case n: BinaryOpNode                      => BinaryOpNodeSerializer.serialize(n)
      //DIRECTIVES
      case n: AnnotationDirectiveNode           => AnnotationDirectiveNodeSerializer.serialize(n)
      case n: FunctionDirectiveNode             => FunctionDirectiveNodeSerializer.serialize(n)
      case n: ImportDirective                   => ImportDirectiveSerializer.serialize(n)
      case n: InputDirective                    => InputDirectiveSerializer.serialize(n)
      case n: OutputDirective                   => OutputDirectiveSerializer.serialize(n)
      case n: NamespaceDirective                => NamespaceDirectiveSerializer.serialize(n)
      case n: TypeDirective                     => TypeDirectiveSerializer.serialize(n)
      case n: VarDirective                      => VarDirectiveSerializer.serialize(n)
      case n: VersionDirective                  => VersionDirectiveSerializer.serialize(n)
      case n: VersionMajor                      => VersionMajorSerializer.serialize(n)
      case n: VersionMinor                      => VersionMinorSerializer.serialize(n)
      case n: AnnotationParametersNode          => AnnotationParametersNodeSerializer.serialize(n)
      case n: AnnotationParameterNode           => AnnotationParameterNodeSerializer.serialize(n)
      case n: DirectiveOption                   => DirectiveOptionSerializer.serialize(n)
      case n: DirectiveOptionName               => DirectiveOptionNameSerializer.serialize(n)
      case n: ImportedElements                  => ImportedElementsSerializer.serialize(n)
      case n: ImportedElement                   => ImportedElementSerializer.serialize(n)
      //DEFAULT
      case n: HeaderNode                        => HeaderNodeSerializer.serialize(n)
      case n: AndNode                           => AndNodeSerializer.serialize(n)
      case n: OrNode                            => OrNodeSerializer.serialize(n)
      case n: ModuleNode                        => ModuleNodeSerializer.serialize(n)
      case n: DynamicKeyNode                    => DynamicKeyNodeSerializer.serialize(n)
      case n: DoBlockNode                       => DoBlockNodeSerializer.serialize(n)
      case n: NullSafeNode                      => NullSafeNodeSerializer.serialize(n)
      case n: NullUnSafeNode                    => NullUnSafeNodeSerializer.serialize(n)
      case n: ConditionalNode                   => ConditionalNodeSerializer.serialize(n)
      case n: IfNode                            => IfNodeSerializer.serialize(n)
      case n: UnlessNode                        => UnlessNodeSerializer.serialize(n)
      case n: FunctionNode                      => FunctionNodeSerializer.serialize(n)
      case n: FunctionParameters                => FunctionParametersSerializer.serialize(n)
      case n: FunctionParameter                 => FunctionParameterSerializer.serialize(n)
      case n: TypeParametersListNode            => TypeParametersListNodeSerializer.serialize(n)
      case n: SchemaNode                        => SchemaNodeSerializer.serialize(n)
      case n: SchemaPropertyNode                => SchemaPropertyNodeSerializer.serialize(n)
      case n: VariableReferenceNode             => VariableReferenceNodeSerializer.serialize(n)
      case n: NameIdentifier                    => NameIdentifierSerializer.serialize(n)
      case n: FunctionCallNode                  => FunctionCallNodeSerializer.serialize(n)
      case n: FunctionCallParametersNode        => FunctionCallParametersNodeSerializer.serialize(n)
      case n: TypeParametersApplicationListNode => TypeParametersApplicationListNodeSerializer.serialize(n)
      case n: ContentType                       => ContentTypeSerializer.serialize(n)
      case n: DataFormatId                      => DataFormatIdSerializer.serialize(n)
      case n: NamespaceNode                     => NamespaceNodeSerializer.serialize(n)
      case n: HeadTailArrayNode                 => HeadTailArrayNodeSerializer.serialize(n)
      case n: HeadTailObjectNode                => HeadTailObjectNodeSerializer.serialize(n)
      case n: StringInterpolationNode           => StringInterpolationNodeSerializer.serialize(n)
      case n: AnnotationNode                    => AnnotationNodeSerializer.serialize(n)
      case n: AnnotationArgumentsNode           => AnnotationArgumentsNodeSerializer.serialize(n)
      case n: AnnotationArgumentNode            => AnnotationArgumentNodeSerializer.serialize(n)
      case n: AttributesNode                    => AttributesNodeSerializer.serialize(n)
      case n: NameValuePairNode                 => NameValuePairNodeSerializer.serialize(n)
      case n: PatternMatcherNode                => PatternMatcherNodeSerializer.serialize(n)
      case n: PatternExpressionsNode            => PatternExpressionsNodeSerializer.serialize(n)
      case n: DeconstructArrayPatternNode       => DeconstructArrayPatternNodeSerializer.serialize(n)
      case n: DeconstructObjectPatternNode      => DeconstructObjectPatternNodeSerializer.serialize(n)
      case n: DefaultPatternNode                => DefaultPatternNodeSerializer.serialize(n)
      case n: EmptyArrayPatternNode             => EmptyArrayPatternNodeSerializer.serialize(n)
      case n: EmptyObjectPatternNode            => EmptyObjectPatternNodeSerializer.serialize(n)
      case n: ExpressionPatternNode             => ExpressionPatternNodeSerializer.serialize(n)
      case n: LiteralPatternNode                => LiteralPatternNodeSerializer.serialize(n)
      case n: RegexPatternNode                  => RegexPatternNodeSerializer.serialize(n)
      case n: TypePatternNode                   => TypePatternNodeSerializer.serialize(n)
      case n: UsingNode                         => UsingNodeSerializer.serialize(n)
      case n: UsingVariableAssignments          => UsingVariableAssignmentsSerializer.serialize(n)
      case n: UsingVariableAssignment           => UsingVariableAssignmentSerializer.serialize(n)
      case n: DefaultNode                       => DefaultNodeSerializer.serialize(n)
      case n: UpdateNode                        => UpdateNodeSerializer.serialize(n)
      case n: UpdateExpressionsNode             => UpdateExpressionsNodeSerializer.serialize(n)
      case n: UpdateExpressionNode              => UpdateExpressionNodeSerializer.serialize(n)
      case n: ArrayIndexUpdateSelectorNode      => ArrayIndexUpdateSelectorNodeSerializer.serialize(n)
      case n: AttributeNameUpdateSelectorNode   => AttributeNameUpdateSelectorNodeSerializer.serialize(n)
      case n: FieldNameUpdateSelectorNode       => FieldNameUpdateSelectorNodeSerializer.serialize(n)
      case n: MultiFieldNameUpdateSelectorNode  => MultiFieldNameUpdateSelectorNodeSerializer.serialize(n)
      case n: ExistsSelectorNode                => ExistsSelectorNodeSerializer.serialize(n)
      case n: DynamicNameNode                   => DynamicNameNodeSerializer.serialize(n)
      case n: OverloadedFunctionNode            => OverloadedFunctionNodeSerializer.serialize(n)
      case n: UndefinedExpressionNode           => UndefinedExpressionNodeSerializer.serialize(n)
      //TYPES
      case n: DynamicReturnTypeNode             => DynamicReturnTypeNodeSerializer.serialize(n)
      case n: FunctionParameterTypeNode         => FunctionParameterTypeNodeSerializer.serialize(n)
      case n: KeyValueTypeNode                  => KeyValueTypeNodeSerializer.serialize(n)
      case n: NameValueTypeNode                 => NameValueTypeNodeSerializer.serialize(n)
      case n: NativeTypeNode                    => NativeTypeNodeSerializer.serialize(n)
      case n: TypeParameterNode                 => TypeParameterNodeSerializer.serialize(n)
      case n: FunctionTypeNode                  => FunctionTypeNodeSerializer.serialize(n)
      case n: IntersectionTypeNode              => IntersectionTypeNodeSerializer.serialize(n)
      case n: KeyTypeNode                       => KeyTypeNodeSerializer.serialize(n)
      case n: LiteralTypeNode                   => LiteralTypeNodeSerializer.serialize(n)
      case n: NameTypeNode                      => NameTypeNodeSerializer.serialize(n)
      case n: ObjectTypeNode                    => ObjectTypeNodeSerializer.serialize(n)
      case n: TypeReferenceNode                 => TypeReferenceNodeSerializer.serialize(n)
      case n: TypeSelectorNode                  => TypeSelectorNodeSerializer.serialize(n)
      case n: UnionTypeNode                     => UnionTypeNodeSerializer.serialize(n)
      case _                                    => throw SerializationException(s"Can't serialize node of class: ${node.getClass}")
    }
  }

  override def deserialize(node: SerializableAstNode, srcResource: WeaveResource, srcIdentifier: NameIdentifier): AstNode = {
    node.kind() match {
      case SerializableAstNodeKind.DOCUMENT_NODE => DocumentNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.HEADER_NODE => HeaderNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      //DIRECTIVES
      case SerializableAstNodeKind.ANNOTATION_DIRECTIVE_NODE => AnnotationDirectiveNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_DIRECTIVE_NODE => FunctionDirectiveNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.IMPORT_DIRECTIVE_NODE => ImportDirectiveSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.INPUT_DIRECTIVE_NODE => InputDirectiveSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.OUTPUT_DIRECTIVE_NODE => OutputDirectiveSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NAMESPACE_DIRECTIVE_NODE => NamespaceDirectiveSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TYPE_DIRECTIVE_NODE => TypeDirectiveSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.VAR_DIRECTIVE_NODE => VarDirectiveSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.VERSION_MAJOR_NODE => VersionMajorSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.VERSION_MINOR_NODE => VersionMinorSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.VERSION_DIRECTIVE_NODE => VersionDirectiveSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DIRECTIVE_OPTION_NODE => DirectiveOptionSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DIRECTIVE_OPTION_NAME_NODE => DirectiveOptionNameSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.IMPORTED_ELEMENTS_NODE => ImportedElementsSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.IMPORTED_ELEMENT_NODE => ImportedElementSerializer.deserialize(node, srcResource, srcIdentifier)
      //OPERATORS
      case SerializableAstNodeKind.UNARY_OP_NODE => UnaryOpNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.BINARY_OP_NODE => BinaryOpNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      //VALUES
      case SerializableAstNodeKind.BOOL_NODE => BooleanNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DATE_TIME_NODE => DateTimeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.LOCAL_DATE_NODE => LocalDateNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.LOCAL_DATE_TIME_NODE => LocalDateTimeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.LOCAL_TIME_NODE => LocalTimeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NULL_NODE => NullNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NUMBER_NODE => NumberNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.PERIOD_NODE => PeriodNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.REGEX_NODE => RegexNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.STRING_NODE => StringNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TIME_NODE => TimeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TIME_ZONE_NODE => TimeZoneNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.URI_NODE => UriNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ARRAY_LITERAL_NODE => ArrayNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.OBJECT_LITERAL_NODE => ObjectNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.KEY_VALUE_PAIR_NODE => KeyValuePairNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.KEY_NODE => KeyNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NAME_NODE => NameNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ANNOTATION_PARAMETERS_NODE => AnnotationParametersNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ANNOTATION_PARAMETER_NODE => AnnotationParameterNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.AND_NODE => AndNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.OR_NODE => OrNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.MODULE_NODE => ModuleNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DYNAMIC_KEY_NODE => DynamicKeyNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DO_BLOCK_NODE => DoBlockNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NULL_SAFE_NODE => NullSafeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NULL_UNSAFE_NODE => NullUnSafeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.CONDITIONAL_NODE => ConditionalNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.IF_NODE => IfNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.UNLESS_NODE => UnlessNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_NODE => FunctionNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_PARAMETERS_NODE => FunctionParametersSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_PARAMETER_NODE => FunctionParameterSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TYPE_PARAMETERS_LIST_NODE => TypeParametersListNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.SCHEMA_NODE => SchemaNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.SCHEMA_PROPERTY_NODE => SchemaPropertyNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.VARIABLE_REFERENCE_NODE => VariableReferenceNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NAME_IDENTIFIER_NODE => NameIdentifierSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_CALL_NODE => FunctionCallNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_CALL_PARAMETERS_NODE => FunctionCallParametersNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TYPE_PARAMETERS_APPLICATION_LIST_NODE => TypeParametersApplicationListNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.CONTENT_TYPE_NODE => ContentTypeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DATA_FORMAT_ID_NODE => DataFormatIdSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NAMESPACE_NODE => NamespaceNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.HEAD_TAIL_ARRAY_NODE => HeadTailArrayNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.HEAD_TAIL_OBJECT_NODE => HeadTailObjectNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.STRING_INTERPOLATION_NODE => StringInterpolationNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ANNOTATION_NODE => AnnotationNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ANNOTATION_ARGUMENTS_NODE => AnnotationArgumentsNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ANNOTATION_ARGUMENT_NODE => AnnotationArgumentNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ATTRIBUTES_NODE => AttributesNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NAME_VALUE_PAIR_NODE => NameValuePairNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.PATTERN_MATCHER_NODE => PatternMatcherNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.PATTERN_EXPRESSIONS_NODE => PatternExpressionsNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DECONSTRUCT_ARRAY_PATTERN_NODE => DeconstructArrayPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DECONSTRUCT_OBJECT_PATTERN_NODE => DeconstructObjectPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DEFAULT_PATTERN_NODE => DefaultPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.EMPTY_ARRAY_PATTERN_NODE => EmptyArrayPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.EMPTY_OBJECT_PATTERN_NODE => EmptyObjectPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.EXPRESSION_PATTERN_NODE => ExpressionPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.LITERAL_PATTERN_NODE => LiteralPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.REGEX_PATTERN_NODE => RegexPatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TYPE_PATTERN_NODE => TypePatternNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.USING_NODE => UsingNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.USING_VARIABLE_ASSIGNMENTS_NODE => UsingVariableAssignmentsSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.USING_VARIABLE_ASSIGNMENT_NODE => UsingVariableAssignmentSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DEFAULT_NODE => DefaultNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.UPDATE_NODE => UpdateNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.UPDATE_EXPRESSIONS_NODE => UpdateExpressionsNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.UPDATE_EXPRESSION_NODE => UpdateExpressionNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ARRAY_INDEX_UPDATE_SELECTOR_NODE => ArrayIndexUpdateSelectorNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.ATTRIBUTE_NAME_UPDATE_SELECTOR_NODE => AttributeNameUpdateSelectorNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FIELD_NAME_UPDATE_SELECTOR_NODE => FieldNameUpdateSelectorNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.MULTI_FIELD_NAME_UPDATE_SELECTOR_NODE => MultiFieldNameUpdateSelectorNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.EXISTS_SELECTOR_NODE => ExistsSelectorNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.DYNAMIC_NAME_NODE => DynamicNameNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.OVERLOADED_FUNCTION_NODE => OverloadedFunctionNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.UNDEFINED_EXPRESSION_NODE => UndefinedExpressionNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      //TYPES
      case SerializableAstNodeKind.DYNAMIC_RETURN_TYPE_NODE => DynamicReturnTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_PARAMETER_TYPE_NODE => FunctionParameterTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.KEY_VALUE_TYPE_NODE => KeyValueTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NAME_VALUE_TYPE_NODE => NameValueTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NATIVE_TYPE_NODE => NativeTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TYPE_PARAMETER_NODE => TypeParameterNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.FUNCTION_TYPE_NODE => FunctionTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.INTERSECTION_TYPE_NODE => IntersectionTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.KEY_TYPE_NODE => KeyTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.LITERAL_TYPE_NODE => LiteralTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.NAME_TYPE_NODE => NameTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.OBJECT_TYPE_NODE => ObjectTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TYPE_REFERENCE_NODE => TypeReferenceNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.TYPE_SELECTOR_NODE => TypeSelectorNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case SerializableAstNodeKind.UNION_TYPE_NODE => UnionTypeNodeSerializer.deserialize(node, srcResource, srcIdentifier)
      case _ => throw DeserializationException(s"Can't deserialize node of kind: ${node.kind()}")
    }
  }
}

