package org.mule.weave.v2.compilation.mapper

import org.mule.weave.v2.compilation
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.UnknownLocation
import org.mule.weave.v2.parser.SafeStringBasedParserInput
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.ParserPosition
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.sdk.WeaveResource

object SerializableLocationMapper {
  def serialize(location: Location): SerializableAstNodeLocation = {
    location match {
      case org.mule.weave.v2.parser.location.UnknownLocation => compilation.UnknownLocation //Unknown
      case location: WeaveLocation                           => SerializableAstNodeLocation(location.startPosition.index, location.endPosition.index)
    }
  }

  def deserialize(location: SerializableAstNodeLocation, srcResource: WeaveResource, srcIdentifier: NameIdentifier): WeaveLocation = {
    location match {
      case UnknownLocation => org.mule.weave.v2.parser.location.UnknownLocation
      case SerializableAstNodeLocation(start, end) =>
        val startPosition = ParserPosition(start, SafeStringBasedParserInput(srcResource.content()))
        val endPosition = ParserPosition(end, SafeStringBasedParserInput(srcResource.content()))
        WeaveLocation(startPosition, endPosition, srcIdentifier)
    }
  }
}
