package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AnnotationArgumentNodeSerializer extends AstNodeSerializer[AnnotationArgumentNode] {

  override protected def doSerialize(node: AnnotationArgumentNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val children = Seq(_annotations, name, value)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_ARGUMENT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AnnotationArgumentNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val value = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    AnnotationArgumentNode(name, value)
  }
}
