package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentsNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AnnotationArgumentsNodeSerializer extends AstNodeSerializer[AnnotationArgumentsNode] {

  override protected def doSerialize(node: AnnotationArgumentsNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val args = AnnotationArgumentNodeSerializer.serializeSeq(node.args)
    val children = Seq(_annotations, args)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_ARGUMENTS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AnnotationArgumentsNode = {
    val args = AnnotationArgumentNodeSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    AnnotationArgumentsNode(args)
  }
}
