package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AnnotationDirectiveNodeSerializer extends AstNodeSerializer[AnnotationDirectiveNode] {

  override protected def doSerialize(node: AnnotationDirectiveNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val identifier = NameIdentifierSerializer.serialize(node.nameIdentifier)
    val params = AnnotationParametersNodeSerializer.serialize(node.params)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, identifier, params, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AnnotationDirectiveNode = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val params = AnnotationParametersNodeSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), srcResource, srcIdentifier)
    AnnotationDirectiveNode(identifier, params, annotations)
  }
}
