package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AnnotationNodeSerializer extends AstNodeSerializer[AnnotationNode] {

  override protected def doSerialize(node: AnnotationNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val args = AnnotationArgumentsNodeSerializer.serializeMaybe(node.args)
    val children = Seq(_annotations, name, args)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AnnotationNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val args = AnnotationArgumentsNodeSerializer.deserializeMaybe(children(1), srcResource, srcIdentifier)
    AnnotationNode(name, args)
  }
}
