package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.header.directives.AnnotationParameterNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AnnotationParameterNodeSerializer extends AstNodeSerializer[AnnotationParameterNode] {

  override protected def doSerialize(node: AnnotationParameterNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val nameIdentifier = NameIdentifierSerializer.serialize(node.nameIdentifier)
    val weaveType = AstToSerializableMapper.serialize(node.weaveType)
    val defaultValue = AstToSerializableMapper.serializeMaybe(node.defaultValue)
    val children: Seq[SerializableAstNode] = Seq(_annotations, nameIdentifier, weaveType, defaultValue)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_PARAMETER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AnnotationParameterNode = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val wtype = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val defaultValue = AstToSerializableMapper.deserializeMaybe(children(2), srcResource, srcIdentifier)
    AnnotationParameterNode(identifier, wtype, defaultValue)
  }
}
