package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.parser.ast.header.directives.AnnotationParametersNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AnnotationParametersNodeSerializer extends AstNodeSerializer[AnnotationParametersNode] {

  override protected def doSerialize(node: AnnotationParametersNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val paramList = AnnotationParameterNodeSerializer.serializeSeq(node.paramList)
    val children: Seq[SerializableAstNode] = Seq(_annotations, paramList)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_PARAMETERS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AnnotationParametersNode = {
    val paramList = AnnotationParameterNodeSerializer.deserializeSeq(children.head, srcResource, srcIdentifier)
    AnnotationParametersNode(paramList)
  }
}
