package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.ArrayNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ArrayNodeSerializer extends AstNodeSerializer[ArrayNode] {

  override protected def doSerialize(node: ArrayNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elements = AstToSerializableMapper.serializeSeq(node.elements)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elements, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.ARRAY_LITERAL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ArrayNode = {
    val elements = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), srcResource, srcIdentifier)
    ArrayNode(elements, annotations)
  }
}
