package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.updates.AttributeNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AttributeNameUpdateSelectorNodeSerializer extends AstNodeSerializer[AttributeNameUpdateSelectorNode] {

  override protected def doSerialize(node: AttributeNameUpdateSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = AstToSerializableMapper.serialize(node.selector)
    val child = AstToSerializableMapper.serializeMaybe(node.child)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, child)
    NodeSerializableAstNode(SerializableAstNodeKind.ATTRIBUTE_NAME_UPDATE_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AttributeNameUpdateSelectorNode = {
    val selector = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val child = AstToSerializableMapper.deserializeMaybe(children(1), srcResource, srcIdentifier)
    AttributeNameUpdateSelectorNode(selector, child)
  }
}
