package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.AttributesNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object AttributesNodeSerializer extends AstNodeSerializer[AttributesNode] {

  override protected def doSerialize(node: AttributesNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val attrs = AstToSerializableMapper.serializeSeq(node.attrs)
    val children = Seq(_annotations, attrs)
    NodeSerializableAstNode(SerializableAstNodeKind.ATTRIBUTES_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): AttributesNode = {
    val attrs = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier)
    AttributesNode(attrs)
  }
}
