package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.compilation.mapper.nonAst.OpIdSerializer
import org.mule.weave.v2.grammar.BinaryOpIdentifier
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object BinaryOpNodeSerializer extends AstNodeSerializer[BinaryOpNode] {

  override protected def doSerialize(node: BinaryOpNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val opId = OpIdSerializer.serialize(node.opId)
    val lhs = AstToSerializableMapper.serialize(node.lhs)
    val rhs = AstToSerializableMapper.serialize(node.rhs)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, opId, lhs, rhs, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.BINARY_OP_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): BinaryOpNode = {
    val op = OpIdSerializer.deserialize(children.head, srcResource, srcIdentifier).asInstanceOf[BinaryOpIdentifier]
    val lhs = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val rhs = AstToSerializableMapper.deserialize(children(2), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    BinaryOpNode(op, lhs, rhs, annotations)
  }
}
