package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.ConditionalNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ConditionalNodeSerializer extends AstNodeSerializer[ConditionalNode] {

  override protected def doSerialize(node: ConditionalNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = AstToSerializableMapper.serialize(node.value)
    val cond = AstToSerializableMapper.serialize(node.cond)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, cond)
    NodeSerializableAstNode(SerializableAstNodeKind.CONDITIONAL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ConditionalNode = {
    val value = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val cond = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    ConditionalNode(value, cond)
  }
}
