package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.parser.ast.header.directives.ContentType
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ContentTypeSerializer extends AstNodeSerializer[ContentType] {

  override protected def doSerialize(node: ContentType, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val mime = serializeString(node.mime)
    val children: Seq[SerializableAstNode] = Seq(_annotations, mime)
    NodeSerializableAstNode(SerializableAstNodeKind.CONTENT_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ContentType = {
    val mime = deserializeString(children.head)
    ContentType(mime)
  }
}
