package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.parser.ast.header.directives.DataFormatId
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object DataFormatIdSerializer extends AstNodeSerializer[DataFormatId] {

  override protected def doSerialize(node: DataFormatId, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val id = serializeString(node.id)
    val children: Seq[SerializableAstNode] = Seq(_annotations, id)
    NodeSerializableAstNode(SerializableAstNodeKind.DATA_FORMAT_ID_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): DataFormatId = {
    val id = deserializeString(children.head)
    DataFormatId(id)
  }
}
