package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.patterns.DeconstructArrayPatternNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object DeconstructArrayPatternNodeSerializer extends AstNodeSerializer[DeconstructArrayPatternNode] {

  override protected def doSerialize(node: DeconstructArrayPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val head = NameIdentifierSerializer.serialize(node.head)
    val tail = NameIdentifierSerializer.serialize(node.tail)
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, head, tail, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.DECONSTRUCT_ARRAY_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): DeconstructArrayPatternNode = {
    val head = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val tail = NameIdentifierSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val onMatch = AstToSerializableMapper.deserialize(children(2), srcResource, srcIdentifier)
    DeconstructArrayPatternNode(head, tail, onMatch)
  }
}
