package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.patterns.DeconstructObjectPatternNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object DeconstructObjectPatternNodeSerializer extends AstNodeSerializer[DeconstructObjectPatternNode] {

  override protected def doSerialize(node: DeconstructObjectPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val headKey = NameIdentifierSerializer.serialize(node.headKey)
    val headValue = NameIdentifierSerializer.serialize(node.headValue)
    val tail = NameIdentifierSerializer.serialize(node.tail)
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, headKey, headValue, tail, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.DECONSTRUCT_OBJECT_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): DeconstructObjectPatternNode = {
    val headKey = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val headValue = NameIdentifierSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val tail = NameIdentifierSerializer.deserialize(children(2), srcResource, srcIdentifier)
    val onMatch = AstToSerializableMapper.deserialize(children(3), srcResource, srcIdentifier)
    DeconstructObjectPatternNode(headKey, headValue, tail, onMatch)
  }
}
