package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.patterns.DefaultPatternNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object DefaultPatternNodeSerializer extends AstNodeSerializer[DefaultPatternNode] {

  override protected def doSerialize(node: DefaultPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val name = NameIdentifierSerializer.serialize(node.name)
    val children: Seq[SerializableAstNode] = Seq(_annotations, onMatch, name)
    NodeSerializableAstNode(SerializableAstNodeKind.DEFAULT_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): DefaultPatternNode = {
    val onMatch = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val name = NameIdentifierSerializer.deserialize(children(1), srcResource, srcIdentifier)
    DefaultPatternNode(onMatch, name)
  }
}
