package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object DocumentNodeSerializer extends AstNodeSerializer[DocumentNode] {

  override protected def doSerialize(node: DocumentNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val header = HeaderNodeSerializer.serialize(node.header)
    val root = AstToSerializableMapper.serialize(node.root)
    val children: Seq[SerializableAstNode] = Seq(_annotations, header, root)
    NodeSerializableAstNode(SerializableAstNodeKind.DOCUMENT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): DocumentNode = {
    val header = HeaderNodeSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val body = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    DocumentNode(header, body)
  }
}
