package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.DynamicKeyNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object DynamicKeyNodeSerializer extends AstNodeSerializer[DynamicKeyNode] {

  override protected def doSerialize(node: DynamicKeyNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val attr = AstToSerializableMapper.serializeMaybe(node.attr)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName, attr)
    NodeSerializableAstNode(SerializableAstNodeKind.DYNAMIC_KEY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): DynamicKeyNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val attr = AstToSerializableMapper.deserializeMaybe(children(1), srcResource, srcIdentifier)
    DynamicKeyNode(keyName, attr)
  }
}
