package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.structure.DynamicNameNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object DynamicNameNodeSerializer extends AstNodeSerializer[DynamicNameNode] {

  override protected def doSerialize(node: DynamicNameNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName)
    NodeSerializableAstNode(SerializableAstNodeKind.DYNAMIC_NAME_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): DynamicNameNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    DynamicNameNode(keyName)
  }
}
