package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.patterns.EmptyArrayPatternNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object EmptyArrayPatternNodeSerializer extends AstNodeSerializer[EmptyArrayPatternNode] {

  override protected def doSerialize(node: EmptyArrayPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.EMPTY_ARRAY_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): EmptyArrayPatternNode = {
    val onMatch = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    EmptyArrayPatternNode(onMatch)
  }
}
