package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.selectors.ExistsSelectorNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object ExistsSelectorNodeSerializer extends AstNodeSerializer[ExistsSelectorNode] {

  override protected def doSerialize(node: ExistsSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selectable = AstToSerializableMapper.serialize(node.selectable)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selectable)
    NodeSerializableAstNode(SerializableAstNodeKind.EXISTS_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): ExistsSelectorNode = {
    val selectable = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    ExistsSelectorNode(selectable)
  }
}
