package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.updates.FieldNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FieldNameUpdateSelectorNodeSerializer extends AstNodeSerializer[FieldNameUpdateSelectorNode] {

  override protected def doSerialize(node: FieldNameUpdateSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = AstToSerializableMapper.serialize(node.selector)
    val child = AstToSerializableMapper.serializeMaybe(node.child)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, child)
    NodeSerializableAstNode(SerializableAstNodeKind.FIELD_NAME_UPDATE_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FieldNameUpdateSelectorNode = {
    val selector = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val child = AstToSerializableMapper.deserializeMaybe(children(1), srcResource, srcIdentifier)
    FieldNameUpdateSelectorNode(selector, child)
  }
}
