package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FunctionCallNodeSerializer extends AstNodeSerializer[FunctionCallNode] {

  override protected def doSerialize(node: FunctionCallNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val function = AstToSerializableMapper.serialize(node.function)
    val args = FunctionCallParametersNodeSerializer.serialize(node.args)
    val typeParameters = TypeParametersApplicationListNodeSerializer.serializeMaybe(node.typeParameters)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, function, args, typeParameters, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_CALL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FunctionCallNode = {
    val function = AstToSerializableMapper.deserialize(children.head, srcResource, srcIdentifier)
    val args = FunctionCallParametersNodeSerializer.deserialize(children(1), srcResource, srcIdentifier)
    val typeParameters = TypeParametersApplicationListNodeSerializer.deserializeMaybe(children(2), srcResource, srcIdentifier)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    FunctionCallNode(function, args, typeParameters, annotations)
  }
}
