package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FunctionCallParametersNodeSerializer extends AstNodeSerializer[FunctionCallParametersNode] {

  override protected def doSerialize(node: FunctionCallParametersNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val args = AstToSerializableMapper.serializeSeq(node.args)
    val children: Seq[SerializableAstNode] = Seq(_annotations, args)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_CALL_PARAMETERS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FunctionCallParametersNode = {
    val args = AstToSerializableMapper.deserializeSeq(children.head, srcResource, srcIdentifier)
    FunctionCallParametersNode(args)
  }
}
