package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FunctionNodeSerializer extends AstNodeSerializer[FunctionNode] {

  override protected def doSerialize(node: FunctionNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val params = FunctionParametersSerializer.serialize(node.params)
    val body = AstToSerializableMapper.serialize(node.body)
    val returnType = AstToSerializableMapper.serializeMaybe(node.returnType)
    val typeParameterList = TypeParametersListNodeSerializer.serializeMaybe(node.typeParameterList)
    val children: Seq[SerializableAstNode] = Seq(_annotations, params, body, returnType, typeParameterList)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FunctionNode = {
    val params = FunctionParametersSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val body = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier)
    val returnType = AstToSerializableMapper.deserializeMaybe(children(2), srcResource, srcIdentifier).asInstanceOf[Option[WeaveTypeNode]]
    val typeParameterList = TypeParametersListNodeSerializer.deserializeMaybe(children(3), srcResource, srcIdentifier)
    FunctionNode(params, body, returnType, typeParameterList)
  }
}
