package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.functions.FunctionParameter
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FunctionParameterSerializer extends AstNodeSerializer[FunctionParameter] {

  override protected def doSerialize(node: FunctionParameter, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val defaultValue = AstToSerializableMapper.serializeMaybe(node.defaultValue)
    val wtype = AstToSerializableMapper.serializeMaybe(node.wtype)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, defaultValue, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_PARAMETER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FunctionParameter = {
    val variable = NameIdentifierSerializer.deserialize(children.head, srcResource, srcIdentifier)
    val defaultValue = AstToSerializableMapper.deserializeMaybe(children(1), srcResource, srcIdentifier)
    val wtype = AstToSerializableMapper.deserializeMaybe(children(2), srcResource, srcIdentifier).asInstanceOf[Option[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), srcResource, srcIdentifier)
    FunctionParameter(variable, defaultValue, wtype, annotations)
  }
}
