package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.ArraySerializableAstNode
import org.mule.weave.v2.compilation.NodeSerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNode
import org.mule.weave.v2.compilation.SerializableAstNodeKind
import org.mule.weave.v2.compilation.SerializableAstNodeLocation
import org.mule.weave.v2.compilation.StringSerializableValueAstNode
import org.mule.weave.v2.compilation.mapper.AstToSerializableMapper
import org.mule.weave.v2.parser.ast.types.FunctionParameterTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResource

object FunctionParameterTypeNodeSerializer extends AstNodeSerializer[FunctionParameterTypeNode] {

  override protected def doSerialize(node: FunctionParameterTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serializeMaybe(node.name)
    val valueType = AstToSerializableMapper.serialize(node.valueType)
    val optional = serializeBoolean(node.optional)
    val children = Seq(_annotations, name, valueType, optional)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_PARAMETER_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], srcResource: WeaveResource, srcIdentifier: NameIdentifier): FunctionParameterTypeNode = {
    val name = NameIdentifierSerializer.deserializeMaybe(children.head, srcResource, srcIdentifier)
    val valueType = AstToSerializableMapper.deserialize(children(1), srcResource, srcIdentifier).asInstanceOf[WeaveTypeNode]
    val optional = deserializeBoolean(children(2))
    FunctionParameterTypeNode(name, valueType, optional)
  }
}
